# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist
from infisicalapi_client.models.api_v1_workspace_project_slug_roles_post200_response_role_permissions_inner import ApiV1WorkspaceProjectSlugRolesPost200ResponseRolePermissionsInner

class ApiV1AdditionalPrivilegeIdentityPermanentPost200ResponsePrivilege(BaseModel):
    """
    ApiV1AdditionalPrivilegeIdentityPermanentPost200ResponsePrivilege
    """
    id: StrictStr = Field(...)
    slug: StrictStr = Field(...)
    project_membership_id: StrictStr = Field(default=..., alias="projectMembershipId")
    is_temporary: Optional[StrictBool] = Field(default=False, alias="isTemporary")
    temporary_mode: Optional[StrictStr] = Field(default=None, alias="temporaryMode")
    temporary_range: Optional[StrictStr] = Field(default=None, alias="temporaryRange")
    temporary_access_start_time: Optional[datetime] = Field(default=None, alias="temporaryAccessStartTime")
    temporary_access_end_time: Optional[datetime] = Field(default=None, alias="temporaryAccessEndTime")
    permissions: conlist(ApiV1WorkspaceProjectSlugRolesPost200ResponseRolePermissionsInner) = Field(...)
    created_at: datetime = Field(default=..., alias="createdAt")
    updated_at: datetime = Field(default=..., alias="updatedAt")
    __properties = ["id", "slug", "projectMembershipId", "isTemporary", "temporaryMode", "temporaryRange", "temporaryAccessStartTime", "temporaryAccessEndTime", "permissions", "createdAt", "updatedAt"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1AdditionalPrivilegeIdentityPermanentPost200ResponsePrivilege:
        """Create an instance of ApiV1AdditionalPrivilegeIdentityPermanentPost200ResponsePrivilege from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in permissions (list)
        _items = []
        if self.permissions:
            for _item in self.permissions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['permissions'] = _items
        # set to None if temporary_mode (nullable) is None
        # and __fields_set__ contains the field
        if self.temporary_mode is None and "temporary_mode" in self.__fields_set__:
            _dict['temporaryMode'] = None

        # set to None if temporary_range (nullable) is None
        # and __fields_set__ contains the field
        if self.temporary_range is None and "temporary_range" in self.__fields_set__:
            _dict['temporaryRange'] = None

        # set to None if temporary_access_start_time (nullable) is None
        # and __fields_set__ contains the field
        if self.temporary_access_start_time is None and "temporary_access_start_time" in self.__fields_set__:
            _dict['temporaryAccessStartTime'] = None

        # set to None if temporary_access_end_time (nullable) is None
        # and __fields_set__ contains the field
        if self.temporary_access_end_time is None and "temporary_access_end_time" in self.__fields_set__:
            _dict['temporaryAccessEndTime'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1AdditionalPrivilegeIdentityPermanentPost200ResponsePrivilege:
        """Create an instance of ApiV1AdditionalPrivilegeIdentityPermanentPost200ResponsePrivilege from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1AdditionalPrivilegeIdentityPermanentPost200ResponsePrivilege.parse_obj(obj)

        _obj = ApiV1AdditionalPrivilegeIdentityPermanentPost200ResponsePrivilege.parse_obj({
            "id": obj.get("id"),
            "slug": obj.get("slug"),
            "project_membership_id": obj.get("projectMembershipId"),
            "is_temporary": obj.get("isTemporary") if obj.get("isTemporary") is not None else False,
            "temporary_mode": obj.get("temporaryMode"),
            "temporary_range": obj.get("temporaryRange"),
            "temporary_access_start_time": obj.get("temporaryAccessStartTime"),
            "temporary_access_end_time": obj.get("temporaryAccessEndTime"),
            "permissions": [ApiV1WorkspaceProjectSlugRolesPost200ResponseRolePermissionsInner.from_dict(_item) for _item in obj.get("permissions")] if obj.get("permissions") is not None else None,
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt")
        })
        return _obj


