# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, StrictStr, conlist, validator
from infisicalapi_client.models.api_v1_additional_privilege_identity_permanent_post_request_privilege_permission_conditions import ApiV1AdditionalPrivilegeIdentityPermanentPostRequestPrivilegePermissionConditions

class ApiV1AdditionalPrivilegeIdentityPermanentPostRequestPrivilegePermission(BaseModel):
    """
    The permission object for the privilege.  # noqa: E501
    """
    actions: conlist(StrictStr, min_items=1) = Field(default=..., description="Describe what action an entity can take. Possible actions: create, edit, delete, and read")
    subject: StrictStr = Field(default=..., description="The entity this permission pertains to. Possible options: secrets, environments")
    conditions: ApiV1AdditionalPrivilegeIdentityPermanentPostRequestPrivilegePermissionConditions = Field(...)
    __properties = ["actions", "subject", "conditions"]

    @validator('actions')
    def actions_validate_enum(cls, value):
        """Validates the enum"""
        for i in value:
            if i not in ('read', 'create', 'edit', 'delete'):
                raise ValueError("each list item must be one of ('read', 'create', 'edit', 'delete')")
        return value

    @validator('subject')
    def subject_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('secrets'):
            raise ValueError("must be one of enum values ('secrets')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1AdditionalPrivilegeIdentityPermanentPostRequestPrivilegePermission:
        """Create an instance of ApiV1AdditionalPrivilegeIdentityPermanentPostRequestPrivilegePermission from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of conditions
        if self.conditions:
            _dict['conditions'] = self.conditions.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1AdditionalPrivilegeIdentityPermanentPostRequestPrivilegePermission:
        """Create an instance of ApiV1AdditionalPrivilegeIdentityPermanentPostRequestPrivilegePermission from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1AdditionalPrivilegeIdentityPermanentPostRequestPrivilegePermission.parse_obj(obj)

        _obj = ApiV1AdditionalPrivilegeIdentityPermanentPostRequestPrivilegePermission.parse_obj({
            "actions": obj.get("actions"),
            "subject": obj.get("subject"),
            "conditions": ApiV1AdditionalPrivilegeIdentityPermanentPostRequestPrivilegePermissionConditions.from_dict(obj.get("conditions")) if obj.get("conditions") is not None else None
        })
        return _obj


