# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist, constr, validator
from infisicalapi_client.models.api_v1_additional_privilege_identity_permanent_post_request_privilege_permission import ApiV1AdditionalPrivilegeIdentityPermanentPostRequestPrivilegePermission
from infisicalapi_client.models.api_v1_workspace_project_slug_roles_post_request_permissions_inner import ApiV1WorkspaceProjectSlugRolesPostRequestPermissionsInner

class ApiV1AdditionalPrivilegeIdentityTemporaryPostRequest(BaseModel):
    """
    ApiV1AdditionalPrivilegeIdentityTemporaryPostRequest
    """
    identity_id: constr(strict=True, min_length=1) = Field(default=..., alias="identityId", description="The ID of the identity to create.")
    project_slug: constr(strict=True, min_length=1) = Field(default=..., alias="projectSlug", description="The slug of the project of the identity in.")
    slug: Optional[constr(strict=True, max_length=60, min_length=1)] = Field(default=None, description="The slug of the privilege to create.")
    permissions: Optional[conlist(ApiV1WorkspaceProjectSlugRolesPostRequestPermissionsInner)] = Field(default=None, description="@deprecated - use privilegePermission The permission object for the privilege. - Read secrets ``` { \"permissions\": [{\"action\": \"read\", \"subject\": \"secrets\"]} ``` - Read and Write secrets ``` { \"permissions\": [{\"action\": \"read\", \"subject\": \"secrets\"], {\"action\": \"write\", \"subject\": \"secrets\"]} ``` - Read secrets scoped to an environment and secret path ``` - { \"permissions\": [{\"action\": \"read\", \"subject\": \"secrets\", \"conditions\": { \"environment\": \"dev\", \"secretPath\": { \"$glob\": \"/\" } }}] } ``` ")
    privilege_permission: Optional[ApiV1AdditionalPrivilegeIdentityPermanentPostRequestPrivilegePermission] = Field(default=None, alias="privilegePermission")
    temporary_mode: StrictStr = Field(default=..., alias="temporaryMode", description="Type of temporary access given. Types: relative")
    temporary_range: StrictStr = Field(default=..., alias="temporaryRange", description="TTL for the temporay time. Eg: 1m, 1h, 1d")
    temporary_access_start_time: datetime = Field(default=..., alias="temporaryAccessStartTime", description="ISO time for which temporary access should begin.")
    __properties = ["identityId", "projectSlug", "slug", "permissions", "privilegePermission", "temporaryMode", "temporaryRange", "temporaryAccessStartTime"]

    @validator('temporary_mode')
    def temporary_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('relative'):
            raise ValueError("must be one of enum values ('relative')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1AdditionalPrivilegeIdentityTemporaryPostRequest:
        """Create an instance of ApiV1AdditionalPrivilegeIdentityTemporaryPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in permissions (list)
        _items = []
        if self.permissions:
            for _item in self.permissions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['permissions'] = _items
        # override the default output from pydantic by calling `to_dict()` of privilege_permission
        if self.privilege_permission:
            _dict['privilegePermission'] = self.privilege_permission.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1AdditionalPrivilegeIdentityTemporaryPostRequest:
        """Create an instance of ApiV1AdditionalPrivilegeIdentityTemporaryPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1AdditionalPrivilegeIdentityTemporaryPostRequest.parse_obj(obj)

        _obj = ApiV1AdditionalPrivilegeIdentityTemporaryPostRequest.parse_obj({
            "identity_id": obj.get("identityId"),
            "project_slug": obj.get("projectSlug"),
            "slug": obj.get("slug"),
            "permissions": [ApiV1WorkspaceProjectSlugRolesPostRequestPermissionsInner.from_dict(_item) for _item in obj.get("permissions")] if obj.get("permissions") is not None else None,
            "privilege_permission": ApiV1AdditionalPrivilegeIdentityPermanentPostRequestPrivilegePermission.from_dict(obj.get("privilegePermission")) if obj.get("privilegePermission") is not None else None,
            "temporary_mode": obj.get("temporaryMode"),
            "temporary_range": obj.get("temporaryRange"),
            "temporary_access_start_time": obj.get("temporaryAccessStartTime")
        })
        return _obj


