# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class ApiV1AuthAwsAuthLoginPostRequest(BaseModel):
    """
    ApiV1AuthAwsAuthLoginPostRequest
    """
    identity_id: StrictStr = Field(default=..., alias="identityId", description="The ID of the identity to login.")
    iam_http_request_method: Optional[StrictStr] = Field(default='POST', alias="iamHttpRequestMethod", description="The HTTP request method used in the signed request.")
    iam_request_body: StrictStr = Field(default=..., alias="iamRequestBody", description="The base64-encoded body of the signed request. Most likely, the base64-encoding of Action=GetCallerIdentity&Version=2011-06-15.")
    iam_request_headers: StrictStr = Field(default=..., alias="iamRequestHeaders", description="The base64-encoded headers of the sts:GetCallerIdentity signed request.")
    __properties = ["identityId", "iamHttpRequestMethod", "iamRequestBody", "iamRequestHeaders"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1AuthAwsAuthLoginPostRequest:
        """Create an instance of ApiV1AuthAwsAuthLoginPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1AuthAwsAuthLoginPostRequest:
        """Create an instance of ApiV1AuthAwsAuthLoginPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1AuthAwsAuthLoginPostRequest.parse_obj(obj)

        _obj = ApiV1AuthAwsAuthLoginPostRequest.parse_obj({
            "identity_id": obj.get("identityId"),
            "iam_http_request_method": obj.get("iamHttpRequestMethod") if obj.get("iamHttpRequestMethod") is not None else 'POST',
            "iam_request_body": obj.get("iamRequestBody"),
            "iam_request_headers": obj.get("iamRequestHeaders")
        })
        return _obj


