# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conint, conlist, validator
from infisicalapi_client.models.api_v1_auth_token_auth_identities_identity_id_post_request_access_token_trusted_ips_inner import ApiV1AuthTokenAuthIdentitiesIdentityIdPostRequestAccessTokenTrustedIpsInner

class ApiV1AuthGcpAuthIdentitiesIdentityIdPatchRequest(BaseModel):
    """
    ApiV1AuthGcpAuthIdentitiesIdentityIdPatchRequest
    """
    type: Optional[StrictStr] = None
    allowed_service_accounts: Optional[StrictStr] = Field(default='', alias="allowedServiceAccounts", description="The new comma-separated list of trusted service account emails corresponding to the GCE resource(s) allowed to authenticate with Infisical.")
    allowed_projects: Optional[StrictStr] = Field(default='', alias="allowedProjects", description="The new comma-separated list of trusted GCP projects that the GCE instance must belong to authenticate with Infisical.")
    allowed_zones: Optional[StrictStr] = Field(default='', alias="allowedZones", description="The new comma-separated list of trusted zones that the GCE instances must belong to authenticate with Infisical.")
    access_token_trusted_ips: Optional[conlist(ApiV1AuthTokenAuthIdentitiesIdentityIdPostRequestAccessTokenTrustedIpsInner, min_items=1)] = Field(default=None, alias="accessTokenTrustedIps", description="The new IPs or CIDR ranges that access tokens can be used from.")
    access_token_ttl: Optional[conint(strict=True, le=315360000, ge=0)] = Field(default=None, alias="accessTokenTTL", description="The new lifetime for an acccess token in seconds.")
    access_token_num_uses_limit: Optional[conint(strict=True, ge=0)] = Field(default=None, alias="accessTokenNumUsesLimit", description="The new maximum number of times that an access token can be used.")
    access_token_max_ttl: Optional[conint(strict=True, le=315360000)] = Field(default=None, alias="accessTokenMaxTTL", description="The new maximum lifetime for an acccess token in seconds.")
    __properties = ["type", "allowedServiceAccounts", "allowedProjects", "allowedZones", "accessTokenTrustedIps", "accessTokenTTL", "accessTokenNumUsesLimit", "accessTokenMaxTTL"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('iam', 'gce'):
            raise ValueError("must be one of enum values ('iam', 'gce')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1AuthGcpAuthIdentitiesIdentityIdPatchRequest:
        """Create an instance of ApiV1AuthGcpAuthIdentitiesIdentityIdPatchRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in access_token_trusted_ips (list)
        _items = []
        if self.access_token_trusted_ips:
            for _item in self.access_token_trusted_ips:
                if _item:
                    _items.append(_item.to_dict())
            _dict['accessTokenTrustedIps'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1AuthGcpAuthIdentitiesIdentityIdPatchRequest:
        """Create an instance of ApiV1AuthGcpAuthIdentitiesIdentityIdPatchRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1AuthGcpAuthIdentitiesIdentityIdPatchRequest.parse_obj(obj)

        _obj = ApiV1AuthGcpAuthIdentitiesIdentityIdPatchRequest.parse_obj({
            "type": obj.get("type"),
            "allowed_service_accounts": obj.get("allowedServiceAccounts") if obj.get("allowedServiceAccounts") is not None else '',
            "allowed_projects": obj.get("allowedProjects") if obj.get("allowedProjects") is not None else '',
            "allowed_zones": obj.get("allowedZones") if obj.get("allowedZones") is not None else '',
            "access_token_trusted_ips": [ApiV1AuthTokenAuthIdentitiesIdentityIdPostRequestAccessTokenTrustedIpsInner.from_dict(_item) for _item in obj.get("accessTokenTrustedIps")] if obj.get("accessTokenTrustedIps") is not None else None,
            "access_token_ttl": obj.get("accessTokenTTL"),
            "access_token_num_uses_limit": obj.get("accessTokenNumUsesLimit"),
            "access_token_max_ttl": obj.get("accessTokenMaxTTL")
        })
        return _obj


