# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr

class ApiV1AuthKubernetesAuthIdentitiesIdentityIdGet200ResponseIdentityKubernetesAuth(BaseModel):
    """
    ApiV1AuthKubernetesAuthIdentitiesIdentityIdGet200ResponseIdentityKubernetesAuth
    """
    id: StrictStr = Field(...)
    access_token_ttl: Optional[Union[StrictFloat, StrictInt]] = Field(default=7200, alias="accessTokenTTL")
    access_token_max_ttl: Optional[Union[StrictFloat, StrictInt]] = Field(default=7200, alias="accessTokenMaxTTL")
    access_token_num_uses_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=0, alias="accessTokenNumUsesLimit")
    access_token_trusted_ips: Optional[Any] = Field(default=None, alias="accessTokenTrustedIps")
    created_at: datetime = Field(default=..., alias="createdAt")
    updated_at: datetime = Field(default=..., alias="updatedAt")
    identity_id: StrictStr = Field(default=..., alias="identityId")
    kubernetes_host: StrictStr = Field(default=..., alias="kubernetesHost")
    allowed_namespaces: StrictStr = Field(default=..., alias="allowedNamespaces")
    allowed_names: StrictStr = Field(default=..., alias="allowedNames")
    allowed_audience: StrictStr = Field(default=..., alias="allowedAudience")
    ca_cert: StrictStr = Field(default=..., alias="caCert")
    token_reviewer_jwt: StrictStr = Field(default=..., alias="tokenReviewerJwt")
    __properties = ["id", "accessTokenTTL", "accessTokenMaxTTL", "accessTokenNumUsesLimit", "accessTokenTrustedIps", "createdAt", "updatedAt", "identityId", "kubernetesHost", "allowedNamespaces", "allowedNames", "allowedAudience", "caCert", "tokenReviewerJwt"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1AuthKubernetesAuthIdentitiesIdentityIdGet200ResponseIdentityKubernetesAuth:
        """Create an instance of ApiV1AuthKubernetesAuthIdentitiesIdentityIdGet200ResponseIdentityKubernetesAuth from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if access_token_trusted_ips (nullable) is None
        # and __fields_set__ contains the field
        if self.access_token_trusted_ips is None and "access_token_trusted_ips" in self.__fields_set__:
            _dict['accessTokenTrustedIps'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1AuthKubernetesAuthIdentitiesIdentityIdGet200ResponseIdentityKubernetesAuth:
        """Create an instance of ApiV1AuthKubernetesAuthIdentitiesIdentityIdGet200ResponseIdentityKubernetesAuth from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1AuthKubernetesAuthIdentitiesIdentityIdGet200ResponseIdentityKubernetesAuth.parse_obj(obj)

        _obj = ApiV1AuthKubernetesAuthIdentitiesIdentityIdGet200ResponseIdentityKubernetesAuth.parse_obj({
            "id": obj.get("id"),
            "access_token_ttl": obj.get("accessTokenTTL") if obj.get("accessTokenTTL") is not None else 7200,
            "access_token_max_ttl": obj.get("accessTokenMaxTTL") if obj.get("accessTokenMaxTTL") is not None else 7200,
            "access_token_num_uses_limit": obj.get("accessTokenNumUsesLimit") if obj.get("accessTokenNumUsesLimit") is not None else 0,
            "access_token_trusted_ips": obj.get("accessTokenTrustedIps"),
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt"),
            "identity_id": obj.get("identityId"),
            "kubernetes_host": obj.get("kubernetesHost"),
            "allowed_namespaces": obj.get("allowedNamespaces"),
            "allowed_names": obj.get("allowedNames"),
            "allowed_audience": obj.get("allowedAudience"),
            "ca_cert": obj.get("caCert"),
            "token_reviewer_jwt": obj.get("tokenReviewerJwt")
        })
        return _obj


