# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Dict, List, Optional
from pydantic import BaseModel, Field, StrictStr, conint, conlist, constr
from infisicalapi_client.models.api_v1_auth_token_auth_identities_identity_id_post_request_access_token_trusted_ips_inner import ApiV1AuthTokenAuthIdentitiesIdentityIdPostRequestAccessTokenTrustedIpsInner

class ApiV1AuthOidcAuthIdentitiesIdentityIdPostRequest(BaseModel):
    """
    ApiV1AuthOidcAuthIdentitiesIdentityIdPostRequest
    """
    oidc_discovery_url: constr(strict=True, min_length=1) = Field(default=..., alias="oidcDiscoveryUrl", description="The URL used to retrieve the OpenID Connect configuration from the identity provider.")
    ca_cert: Optional[StrictStr] = Field(default='', alias="caCert", description="The PEM-encoded CA cert for establishing secure communication with the Identity Provider endpoints.")
    bound_issuer: constr(strict=True, min_length=1) = Field(default=..., alias="boundIssuer", description="The unique identifier of the identity provider issuing the JWT.")
    bound_audiences: Optional[StrictStr] = Field(default='', alias="boundAudiences", description="The list of intended recipients.")
    bound_claims: Dict[str, StrictStr] = Field(default=..., alias="boundClaims", description="The attributes that should be present in the JWT for it to be valid.")
    bound_subject: Optional[StrictStr] = Field(default='', alias="boundSubject", description="The expected principal that is the subject of the JWT.")
    access_token_trusted_ips: Optional[conlist(ApiV1AuthTokenAuthIdentitiesIdentityIdPostRequestAccessTokenTrustedIpsInner, min_items=1)] = Field(default=None, alias="accessTokenTrustedIps", description="The IPs or CIDR ranges that access tokens can be used from.")
    access_token_ttl: Optional[conint(strict=True, le=315360000, ge=1)] = Field(default=2592000, alias="accessTokenTTL", description="The lifetime for an acccess token in seconds.")
    access_token_max_ttl: Optional[conint(strict=True, le=315360000)] = Field(default=2592000, alias="accessTokenMaxTTL", description="The maximum lifetime for an acccess token in seconds.")
    access_token_num_uses_limit: Optional[conint(strict=True, ge=0)] = Field(default=0, alias="accessTokenNumUsesLimit", description="The maximum number of times that an access token can be used.")
    __properties = ["oidcDiscoveryUrl", "caCert", "boundIssuer", "boundAudiences", "boundClaims", "boundSubject", "accessTokenTrustedIps", "accessTokenTTL", "accessTokenMaxTTL", "accessTokenNumUsesLimit"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1AuthOidcAuthIdentitiesIdentityIdPostRequest:
        """Create an instance of ApiV1AuthOidcAuthIdentitiesIdentityIdPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in access_token_trusted_ips (list)
        _items = []
        if self.access_token_trusted_ips:
            for _item in self.access_token_trusted_ips:
                if _item:
                    _items.append(_item.to_dict())
            _dict['accessTokenTrustedIps'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1AuthOidcAuthIdentitiesIdentityIdPostRequest:
        """Create an instance of ApiV1AuthOidcAuthIdentitiesIdentityIdPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1AuthOidcAuthIdentitiesIdentityIdPostRequest.parse_obj(obj)

        _obj = ApiV1AuthOidcAuthIdentitiesIdentityIdPostRequest.parse_obj({
            "oidc_discovery_url": obj.get("oidcDiscoveryUrl"),
            "ca_cert": obj.get("caCert") if obj.get("caCert") is not None else '',
            "bound_issuer": obj.get("boundIssuer"),
            "bound_audiences": obj.get("boundAudiences") if obj.get("boundAudiences") is not None else '',
            "bound_claims": obj.get("boundClaims"),
            "bound_subject": obj.get("boundSubject") if obj.get("boundSubject") is not None else '',
            "access_token_trusted_ips": [ApiV1AuthTokenAuthIdentitiesIdentityIdPostRequestAccessTokenTrustedIpsInner.from_dict(_item) for _item in obj.get("accessTokenTrustedIps")] if obj.get("accessTokenTrustedIps") is not None else None,
            "access_token_ttl": obj.get("accessTokenTTL") if obj.get("accessTokenTTL") is not None else 2592000,
            "access_token_max_ttl": obj.get("accessTokenMaxTTL") if obj.get("accessTokenMaxTTL") is not None else 2592000,
            "access_token_num_uses_limit": obj.get("accessTokenNumUsesLimit") if obj.get("accessTokenNumUsesLimit") is not None else 0
        })
        return _obj


