# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional, Union
from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr

class ApiV1AuthTokenAuthIdentitiesIdentityIdTokensGet200ResponseTokensInner(BaseModel):
    """
    ApiV1AuthTokenAuthIdentitiesIdentityIdTokensGet200ResponseTokensInner
    """
    id: StrictStr = Field(...)
    access_token_ttl: Optional[Union[StrictFloat, StrictInt]] = Field(default=2592000, alias="accessTokenTTL")
    access_token_max_ttl: Optional[Union[StrictFloat, StrictInt]] = Field(default=2592000, alias="accessTokenMaxTTL")
    access_token_num_uses: Optional[Union[StrictFloat, StrictInt]] = Field(default=0, alias="accessTokenNumUses")
    access_token_num_uses_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=0, alias="accessTokenNumUsesLimit")
    access_token_last_used_at: Optional[datetime] = Field(default=None, alias="accessTokenLastUsedAt")
    access_token_last_renewed_at: Optional[datetime] = Field(default=None, alias="accessTokenLastRenewedAt")
    is_access_token_revoked: Optional[StrictBool] = Field(default=False, alias="isAccessTokenRevoked")
    identity_ua_client_secret_id: Optional[StrictStr] = Field(default=None, alias="identityUAClientSecretId")
    identity_id: StrictStr = Field(default=..., alias="identityId")
    created_at: datetime = Field(default=..., alias="createdAt")
    updated_at: datetime = Field(default=..., alias="updatedAt")
    name: Optional[StrictStr] = None
    __properties = ["id", "accessTokenTTL", "accessTokenMaxTTL", "accessTokenNumUses", "accessTokenNumUsesLimit", "accessTokenLastUsedAt", "accessTokenLastRenewedAt", "isAccessTokenRevoked", "identityUAClientSecretId", "identityId", "createdAt", "updatedAt", "name"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1AuthTokenAuthIdentitiesIdentityIdTokensGet200ResponseTokensInner:
        """Create an instance of ApiV1AuthTokenAuthIdentitiesIdentityIdTokensGet200ResponseTokensInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if access_token_last_used_at (nullable) is None
        # and __fields_set__ contains the field
        if self.access_token_last_used_at is None and "access_token_last_used_at" in self.__fields_set__:
            _dict['accessTokenLastUsedAt'] = None

        # set to None if access_token_last_renewed_at (nullable) is None
        # and __fields_set__ contains the field
        if self.access_token_last_renewed_at is None and "access_token_last_renewed_at" in self.__fields_set__:
            _dict['accessTokenLastRenewedAt'] = None

        # set to None if identity_ua_client_secret_id (nullable) is None
        # and __fields_set__ contains the field
        if self.identity_ua_client_secret_id is None and "identity_ua_client_secret_id" in self.__fields_set__:
            _dict['identityUAClientSecretId'] = None

        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1AuthTokenAuthIdentitiesIdentityIdTokensGet200ResponseTokensInner:
        """Create an instance of ApiV1AuthTokenAuthIdentitiesIdentityIdTokensGet200ResponseTokensInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1AuthTokenAuthIdentitiesIdentityIdTokensGet200ResponseTokensInner.parse_obj(obj)

        _obj = ApiV1AuthTokenAuthIdentitiesIdentityIdTokensGet200ResponseTokensInner.parse_obj({
            "id": obj.get("id"),
            "access_token_ttl": obj.get("accessTokenTTL") if obj.get("accessTokenTTL") is not None else 2592000,
            "access_token_max_ttl": obj.get("accessTokenMaxTTL") if obj.get("accessTokenMaxTTL") is not None else 2592000,
            "access_token_num_uses": obj.get("accessTokenNumUses") if obj.get("accessTokenNumUses") is not None else 0,
            "access_token_num_uses_limit": obj.get("accessTokenNumUsesLimit") if obj.get("accessTokenNumUsesLimit") is not None else 0,
            "access_token_last_used_at": obj.get("accessTokenLastUsedAt"),
            "access_token_last_renewed_at": obj.get("accessTokenLastRenewedAt"),
            "is_access_token_revoked": obj.get("isAccessTokenRevoked") if obj.get("isAccessTokenRevoked") is not None else False,
            "identity_ua_client_secret_id": obj.get("identityUAClientSecretId"),
            "identity_id": obj.get("identityId"),
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt"),
            "name": obj.get("name")
        })
        return _obj


