# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictStr, confloat, conint

class ApiV1AuthUniversalAuthIdentitiesIdentityIdClientSecretsPostRequest(BaseModel):
    """
    ApiV1AuthUniversalAuthIdentitiesIdentityIdClientSecretsPostRequest
    """
    description: Optional[StrictStr] = Field(default='', description="The description of the client secret.")
    num_uses_limit: Optional[Union[confloat(ge=0, strict=True), conint(ge=0, strict=True)]] = Field(default=0, alias="numUsesLimit", description="The maximum number of times that the client secret can be used; a value of 0 implies infinite number of uses.")
    ttl: Optional[Union[confloat(le=315360000, ge=0, strict=True), conint(le=315360000, ge=0, strict=True)]] = Field(default=0, description="The lifetime for the client secret in seconds.")
    __properties = ["description", "numUsesLimit", "ttl"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1AuthUniversalAuthIdentitiesIdentityIdClientSecretsPostRequest:
        """Create an instance of ApiV1AuthUniversalAuthIdentitiesIdentityIdClientSecretsPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1AuthUniversalAuthIdentitiesIdentityIdClientSecretsPostRequest:
        """Create an instance of ApiV1AuthUniversalAuthIdentitiesIdentityIdClientSecretsPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1AuthUniversalAuthIdentitiesIdentityIdClientSecretsPostRequest.parse_obj(obj)

        _obj = ApiV1AuthUniversalAuthIdentitiesIdentityIdClientSecretsPostRequest.parse_obj({
            "description": obj.get("description") if obj.get("description") is not None else '',
            "num_uses_limit": obj.get("numUsesLimit") if obj.get("numUsesLimit") is not None else 0,
            "ttl": obj.get("ttl") if obj.get("ttl") is not None else 0
        })
        return _obj


