# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, constr
from infisicalapi_client.models.api_v1_dynamic_secrets_name_patch_request_data import ApiV1DynamicSecretsNamePatchRequestData

class ApiV1DynamicSecretsNamePatchRequest(BaseModel):
    """
    ApiV1DynamicSecretsNamePatchRequest
    """
    project_slug: constr(strict=True, min_length=1) = Field(default=..., alias="projectSlug", description="The slug of the project to update dynamic secret in.")
    path: Optional[StrictStr] = Field(default='/', description="The path to update the dynamic secret in.")
    environment_slug: constr(strict=True, min_length=1) = Field(default=..., alias="environmentSlug", description="The slug of the environment to update the dynamic secret in.")
    data: ApiV1DynamicSecretsNamePatchRequestData = Field(...)
    __properties = ["projectSlug", "path", "environmentSlug", "data"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1DynamicSecretsNamePatchRequest:
        """Create an instance of ApiV1DynamicSecretsNamePatchRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of data
        if self.data:
            _dict['data'] = self.data.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1DynamicSecretsNamePatchRequest:
        """Create an instance of ApiV1DynamicSecretsNamePatchRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1DynamicSecretsNamePatchRequest.parse_obj(obj)

        _obj = ApiV1DynamicSecretsNamePatchRequest.parse_obj({
            "project_slug": obj.get("projectSlug"),
            "path": obj.get("path") if obj.get("path") is not None else '/',
            "environment_slug": obj.get("environmentSlug"),
            "data": ApiV1DynamicSecretsNamePatchRequestData.from_dict(obj.get("data")) if obj.get("data") is not None else None
        })
        return _obj


