# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, constr

class ApiV1DynamicSecretsPostRequestProviderAnyOf1Inputs(BaseModel):
    """
    ApiV1DynamicSecretsPostRequestProviderAnyOf1Inputs
    """
    host: StrictStr = Field(...)
    port: Union[StrictFloat, StrictInt] = Field(...)
    local_data_center: constr(strict=True, min_length=1) = Field(default=..., alias="localDataCenter")
    keyspace: Optional[StrictStr] = None
    username: StrictStr = Field(...)
    password: StrictStr = Field(...)
    creation_statement: StrictStr = Field(default=..., alias="creationStatement")
    revocation_statement: StrictStr = Field(default=..., alias="revocationStatement")
    renew_statement: Optional[StrictStr] = Field(default=None, alias="renewStatement")
    ca: Optional[StrictStr] = None
    __properties = ["host", "port", "localDataCenter", "keyspace", "username", "password", "creationStatement", "revocationStatement", "renewStatement", "ca"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1DynamicSecretsPostRequestProviderAnyOf1Inputs:
        """Create an instance of ApiV1DynamicSecretsPostRequestProviderAnyOf1Inputs from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1DynamicSecretsPostRequestProviderAnyOf1Inputs:
        """Create an instance of ApiV1DynamicSecretsPostRequestProviderAnyOf1Inputs from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1DynamicSecretsPostRequestProviderAnyOf1Inputs.parse_obj(obj)

        _obj = ApiV1DynamicSecretsPostRequestProviderAnyOf1Inputs.parse_obj({
            "host": obj.get("host"),
            "port": obj.get("port"),
            "local_data_center": obj.get("localDataCenter"),
            "keyspace": obj.get("keyspace"),
            "username": obj.get("username"),
            "password": obj.get("password"),
            "creation_statement": obj.get("creationStatement"),
            "revocation_statement": obj.get("revocationStatement"),
            "renew_statement": obj.get("renewStatement"),
            "ca": obj.get("ca")
        })
        return _obj


