# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, constr

class ApiV1DynamicSecretsPostRequestProviderAnyOf2Inputs(BaseModel):
    """
    ApiV1DynamicSecretsPostRequestProviderAnyOf2Inputs
    """
    access_key: constr(strict=True, min_length=1) = Field(default=..., alias="accessKey")
    secret_access_key: constr(strict=True, min_length=1) = Field(default=..., alias="secretAccessKey")
    region: constr(strict=True, min_length=1) = Field(...)
    aws_path: Optional[StrictStr] = Field(default=None, alias="awsPath")
    permission_boundary_policy_arn: Optional[StrictStr] = Field(default=None, alias="permissionBoundaryPolicyArn")
    policy_document: Optional[StrictStr] = Field(default=None, alias="policyDocument")
    user_groups: Optional[StrictStr] = Field(default=None, alias="userGroups")
    policy_arns: Optional[StrictStr] = Field(default=None, alias="policyArns")
    __properties = ["accessKey", "secretAccessKey", "region", "awsPath", "permissionBoundaryPolicyArn", "policyDocument", "userGroups", "policyArns"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1DynamicSecretsPostRequestProviderAnyOf2Inputs:
        """Create an instance of ApiV1DynamicSecretsPostRequestProviderAnyOf2Inputs from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1DynamicSecretsPostRequestProviderAnyOf2Inputs:
        """Create an instance of ApiV1DynamicSecretsPostRequestProviderAnyOf2Inputs from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1DynamicSecretsPostRequestProviderAnyOf2Inputs.parse_obj(obj)

        _obj = ApiV1DynamicSecretsPostRequestProviderAnyOf2Inputs.parse_obj({
            "access_key": obj.get("accessKey"),
            "secret_access_key": obj.get("secretAccessKey"),
            "region": obj.get("region"),
            "aws_path": obj.get("awsPath"),
            "permission_boundary_policy_arn": obj.get("permissionBoundaryPolicyArn"),
            "policy_document": obj.get("policyDocument"),
            "user_groups": obj.get("userGroups"),
            "policy_arns": obj.get("policyArns")
        })
        return _obj


