# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, constr
from infisicalapi_client.models.api_v1_external_kms_post_request_provider_inputs_credential import ApiV1ExternalKmsPostRequestProviderInputsCredential

class ApiV1ExternalKmsPostRequestProviderInputs(BaseModel):
    """
    ApiV1ExternalKmsPostRequestProviderInputs
    """
    credential: ApiV1ExternalKmsPostRequestProviderInputsCredential = Field(...)
    aws_region: constr(strict=True, min_length=1) = Field(default=..., alias="awsRegion", description="AWS region to connect")
    kms_key_id: Optional[StrictStr] = Field(default=None, alias="kmsKeyId", description="A pre existing AWS KMS key id to be used for encryption. If not provided a kms key will be generated.")
    __properties = ["credential", "awsRegion", "kmsKeyId"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1ExternalKmsPostRequestProviderInputs:
        """Create an instance of ApiV1ExternalKmsPostRequestProviderInputs from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of credential
        if self.credential:
            _dict['credential'] = self.credential.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1ExternalKmsPostRequestProviderInputs:
        """Create an instance of ApiV1ExternalKmsPostRequestProviderInputs from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1ExternalKmsPostRequestProviderInputs.parse_obj(obj)

        _obj = ApiV1ExternalKmsPostRequestProviderInputs.parse_obj({
            "credential": ApiV1ExternalKmsPostRequestProviderInputsCredential.from_dict(obj.get("credential")) if obj.get("credential") is not None else None,
            "aws_region": obj.get("awsRegion"),
            "kms_key_id": obj.get("kmsKeyId")
        })
        return _obj


