# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, StrictStr, conlist
from infisicalapi_client.models.api_v1_folders_batch_patch_request_folders_inner import ApiV1FoldersBatchPatchRequestFoldersInner

class ApiV1FoldersBatchPatchRequest(BaseModel):
    """
    ApiV1FoldersBatchPatchRequest
    """
    project_slug: StrictStr = Field(default=..., alias="projectSlug", description="The slug of the project where the folder is located.")
    folders: conlist(ApiV1FoldersBatchPatchRequestFoldersInner, min_items=1) = Field(...)
    __properties = ["projectSlug", "folders"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1FoldersBatchPatchRequest:
        """Create an instance of ApiV1FoldersBatchPatchRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in folders (list)
        _items = []
        if self.folders:
            for _item in self.folders:
                if _item:
                    _items.append(_item.to_dict())
            _dict['folders'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1FoldersBatchPatchRequest:
        """Create an instance of ApiV1FoldersBatchPatchRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1FoldersBatchPatchRequest.parse_obj(obj)

        _obj = ApiV1FoldersBatchPatchRequest.parse_obj({
            "project_slug": obj.get("projectSlug"),
            "folders": [ApiV1FoldersBatchPatchRequestFoldersInner.from_dict(_item) for _item in obj.get("folders")] if obj.get("folders") is not None else None
        })
        return _obj


