# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class ApiV1IntegrationAuthAccessTokenPostRequest(BaseModel):
    """
    ApiV1IntegrationAuthAccessTokenPostRequest
    """
    workspace_id: StrictStr = Field(default=..., alias="workspaceId", description="The ID of the project to create the integration auth for.")
    integration: StrictStr = Field(default=..., description="The slug of integration for the auth object.")
    access_id: Optional[StrictStr] = Field(default=None, alias="accessId", description="The unique authorized access id of the external integration provider.")
    access_token: Optional[StrictStr] = Field(default=None, alias="accessToken", description="The unique authorized access token of the external integration provider.")
    aws_assume_iam_role_arn: Optional[StrictStr] = Field(default=None, alias="awsAssumeIamRoleArn", description="The AWS IAM Role to be assumed by Infisical")
    url: Optional[StrictStr] = None
    namespace: Optional[StrictStr] = None
    refresh_token: Optional[StrictStr] = Field(default=None, alias="refreshToken", description="The refresh token for integration authorization.")
    __properties = ["workspaceId", "integration", "accessId", "accessToken", "awsAssumeIamRoleArn", "url", "namespace", "refreshToken"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1IntegrationAuthAccessTokenPostRequest:
        """Create an instance of ApiV1IntegrationAuthAccessTokenPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1IntegrationAuthAccessTokenPostRequest:
        """Create an instance of ApiV1IntegrationAuthAccessTokenPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1IntegrationAuthAccessTokenPostRequest.parse_obj(obj)

        _obj = ApiV1IntegrationAuthAccessTokenPostRequest.parse_obj({
            "workspace_id": obj.get("workspaceId"),
            "integration": obj.get("integration"),
            "access_id": obj.get("accessId"),
            "access_token": obj.get("accessToken"),
            "aws_assume_iam_role_arn": obj.get("awsAssumeIamRoleArn"),
            "url": obj.get("url"),
            "namespace": obj.get("namespace"),
            "refresh_token": obj.get("refreshToken")
        })
        return _obj


