# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr
from infisicalapi_client.models.api_v1_integration_post_request_metadata import ApiV1IntegrationPostRequestMetadata

class ApiV1IntegrationPostRequest(BaseModel):
    """
    ApiV1IntegrationPostRequest
    """
    integration_auth_id: StrictStr = Field(default=..., alias="integrationAuthId", description="The ID of the integration auth object to link with integration.")
    app: Optional[StrictStr] = Field(default=None, description="The name of the external integration providers app entity that you want to sync secrets with. Used in Netlify, GitHub, Vercel integrations.")
    is_active: Optional[StrictBool] = Field(default=True, alias="isActive", description="Whether the integration should be active or disabled.")
    app_id: Optional[StrictStr] = Field(default=None, alias="appId", description="The ID of the external integration providers app entity that you want to sync secrets with. Used in Netlify, GitHub, Vercel integrations.")
    secret_path: Optional[StrictStr] = Field(default='/', alias="secretPath", description="The path of the secrets to sync secrets from.")
    source_environment: StrictStr = Field(default=..., alias="sourceEnvironment", description="The environment to sync secret from.")
    target_environment: Optional[StrictStr] = Field(default=None, alias="targetEnvironment", description="The target environment of the integration provider. Used in cloudflare pages, TeamCity, Gitlab integrations.")
    target_environment_id: Optional[StrictStr] = Field(default=None, alias="targetEnvironmentId", description="The target environment id of the integration provider. Used in cloudflare pages, teamcity, gitlab integrations.")
    target_service: Optional[StrictStr] = Field(default=None, alias="targetService", description="The service based grouping identifier of the external provider. Used in Terraform cloud, Checkly, Railway and NorthFlank")
    target_service_id: Optional[StrictStr] = Field(default=None, alias="targetServiceId", description="The service based grouping identifier ID of the external provider. Used in Terraform cloud, Checkly, Railway and NorthFlank")
    owner: Optional[StrictStr] = Field(default=None, description="External integration providers service entity owner. Used in Github.")
    url: Optional[StrictStr] = Field(default=None, description="The self-hosted URL of the platform to integrate with")
    path: Optional[StrictStr] = Field(default=None, description="Path to save the synced secrets. Used by Gitlab, AWS Parameter Store, Vault")
    region: Optional[StrictStr] = Field(default=None, description="AWS region to sync secrets to.")
    scope: Optional[StrictStr] = Field(default=None, description="Scope of the provider. Used by Github, Qovery")
    metadata: Optional[ApiV1IntegrationPostRequestMetadata] = None
    __properties = ["integrationAuthId", "app", "isActive", "appId", "secretPath", "sourceEnvironment", "targetEnvironment", "targetEnvironmentId", "targetService", "targetServiceId", "owner", "url", "path", "region", "scope", "metadata"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1IntegrationPostRequest:
        """Create an instance of ApiV1IntegrationPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1IntegrationPostRequest:
        """Create an instance of ApiV1IntegrationPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1IntegrationPostRequest.parse_obj(obj)

        _obj = ApiV1IntegrationPostRequest.parse_obj({
            "integration_auth_id": obj.get("integrationAuthId"),
            "app": obj.get("app"),
            "is_active": obj.get("isActive") if obj.get("isActive") is not None else True,
            "app_id": obj.get("appId"),
            "secret_path": obj.get("secretPath") if obj.get("secretPath") is not None else '/',
            "source_environment": obj.get("sourceEnvironment"),
            "target_environment": obj.get("targetEnvironment"),
            "target_environment_id": obj.get("targetEnvironmentId"),
            "target_service": obj.get("targetService"),
            "target_service_id": obj.get("targetServiceId"),
            "owner": obj.get("owner"),
            "url": obj.get("url"),
            "path": obj.get("path"),
            "region": obj.get("region"),
            "scope": obj.get("scope"),
            "metadata": ApiV1IntegrationPostRequestMetadata.from_dict(obj.get("metadata")) if obj.get("metadata") is not None else None
        })
        return _obj


