# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist, validator
from infisicalapi_client.models.api_v1_audit_log_streams_id_get200_response_audit_log_stream_headers_inner import ApiV1AuditLogStreamsIdGet200ResponseAuditLogStreamHeadersInner
from infisicalapi_client.models.api_v1_integration_post_request_metadata_secret_gcp_label import ApiV1IntegrationPostRequestMetadataSecretGCPLabel

class ApiV1IntegrationPostRequestMetadata(BaseModel):
    """
    ApiV1IntegrationPostRequestMetadata
    """
    secret_prefix: Optional[StrictStr] = Field(default=None, alias="secretPrefix", description="The prefix for the saved secret. Used by GCP.")
    secret_suffix: Optional[StrictStr] = Field(default=None, alias="secretSuffix", description="The suffix for the saved secret. Used by GCP.")
    initial_sync_behavior: Optional[StrictStr] = Field(default=None, alias="initialSyncBehavior", description="Type of syncing behavoir with the integration.")
    mapping_behavior: Optional[StrictStr] = Field(default=None, alias="mappingBehavior", description="The mapping behavior of the integration.")
    should_auto_redeploy: Optional[StrictBool] = Field(default=None, alias="shouldAutoRedeploy", description="Used by Render to trigger auto deploy.")
    secret_gcp_label: Optional[ApiV1IntegrationPostRequestMetadataSecretGCPLabel] = Field(default=None, alias="secretGCPLabel")
    secret_aws_tag: Optional[conlist(ApiV1AuditLogStreamsIdGet200ResponseAuditLogStreamHeadersInner)] = Field(default=None, alias="secretAWSTag", description="The tags for AWS secrets.")
    kms_key_id: Optional[StrictStr] = Field(default=None, alias="kmsKeyId", description="The ID of the encryption key from AWS KMS.")
    should_disable_delete: Optional[StrictBool] = Field(default=None, alias="shouldDisableDelete", description="The flag to disable deletion of secrets in AWS Parameter Store.")
    should_enable_delete: Optional[StrictBool] = Field(default=None, alias="shouldEnableDelete", description="The flag to enable deletion of secrets")
    should_mask_secrets: Optional[StrictBool] = Field(default=None, alias="shouldMaskSecrets", description="Specifies if the secrets synced from Infisical to Gitlab should be marked as 'Masked'.")
    should_protect_secrets: Optional[StrictBool] = Field(default=None, alias="shouldProtectSecrets", description="Specifies if the secrets synced from Infisical to Gitlab should be marked as 'Protected'.")
    __properties = ["secretPrefix", "secretSuffix", "initialSyncBehavior", "mappingBehavior", "shouldAutoRedeploy", "secretGCPLabel", "secretAWSTag", "kmsKeyId", "shouldDisableDelete", "shouldEnableDelete", "shouldMaskSecrets", "shouldProtectSecrets"]

    @validator('mapping_behavior')
    def mapping_behavior_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('one-to-one', 'many-to-one'):
            raise ValueError("must be one of enum values ('one-to-one', 'many-to-one')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1IntegrationPostRequestMetadata:
        """Create an instance of ApiV1IntegrationPostRequestMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of secret_gcp_label
        if self.secret_gcp_label:
            _dict['secretGCPLabel'] = self.secret_gcp_label.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in secret_aws_tag (list)
        _items = []
        if self.secret_aws_tag:
            for _item in self.secret_aws_tag:
                if _item:
                    _items.append(_item.to_dict())
            _dict['secretAWSTag'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1IntegrationPostRequestMetadata:
        """Create an instance of ApiV1IntegrationPostRequestMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1IntegrationPostRequestMetadata.parse_obj(obj)

        _obj = ApiV1IntegrationPostRequestMetadata.parse_obj({
            "secret_prefix": obj.get("secretPrefix"),
            "secret_suffix": obj.get("secretSuffix"),
            "initial_sync_behavior": obj.get("initialSyncBehavior"),
            "mapping_behavior": obj.get("mappingBehavior"),
            "should_auto_redeploy": obj.get("shouldAutoRedeploy"),
            "secret_gcp_label": ApiV1IntegrationPostRequestMetadataSecretGCPLabel.from_dict(obj.get("secretGCPLabel")) if obj.get("secretGCPLabel") is not None else None,
            "secret_aws_tag": [ApiV1AuditLogStreamsIdGet200ResponseAuditLogStreamHeadersInner.from_dict(_item) for _item in obj.get("secretAWSTag")] if obj.get("secretAWSTag") is not None else None,
            "kms_key_id": obj.get("kmsKeyId"),
            "should_disable_delete": obj.get("shouldDisableDelete"),
            "should_enable_delete": obj.get("shouldEnableDelete"),
            "should_mask_secrets": obj.get("shouldMaskSecrets"),
            "should_protect_secrets": obj.get("shouldProtectSecrets")
        })
        return _obj


