# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr

class ApiV1LdapConfigPost200Response(BaseModel):
    """
    ApiV1LdapConfigPost200Response
    """
    id: StrictStr = Field(...)
    org_id: StrictStr = Field(default=..., alias="orgId")
    is_active: StrictBool = Field(default=..., alias="isActive")
    url: StrictStr = Field(...)
    encrypted_bind_dn: StrictStr = Field(default=..., alias="encryptedBindDN")
    bind_dniv: StrictStr = Field(default=..., alias="bindDNIV")
    bind_dn_tag: StrictStr = Field(default=..., alias="bindDNTag")
    encrypted_bind_pass: StrictStr = Field(default=..., alias="encryptedBindPass")
    bind_pass_iv: StrictStr = Field(default=..., alias="bindPassIV")
    bind_pass_tag: StrictStr = Field(default=..., alias="bindPassTag")
    search_base: StrictStr = Field(default=..., alias="searchBase")
    encrypted_ca_cert: StrictStr = Field(default=..., alias="encryptedCACert")
    ca_cert_iv: StrictStr = Field(default=..., alias="caCertIV")
    ca_cert_tag: StrictStr = Field(default=..., alias="caCertTag")
    created_at: datetime = Field(default=..., alias="createdAt")
    updated_at: datetime = Field(default=..., alias="updatedAt")
    group_search_base: Optional[StrictStr] = Field(default='', alias="groupSearchBase")
    group_search_filter: Optional[StrictStr] = Field(default='', alias="groupSearchFilter")
    search_filter: Optional[StrictStr] = Field(default='', alias="searchFilter")
    unique_user_attribute: Optional[StrictStr] = Field(default='', alias="uniqueUserAttribute")
    __properties = ["id", "orgId", "isActive", "url", "encryptedBindDN", "bindDNIV", "bindDNTag", "encryptedBindPass", "bindPassIV", "bindPassTag", "searchBase", "encryptedCACert", "caCertIV", "caCertTag", "createdAt", "updatedAt", "groupSearchBase", "groupSearchFilter", "searchFilter", "uniqueUserAttribute"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1LdapConfigPost200Response:
        """Create an instance of ApiV1LdapConfigPost200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1LdapConfigPost200Response:
        """Create an instance of ApiV1LdapConfigPost200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1LdapConfigPost200Response.parse_obj(obj)

        _obj = ApiV1LdapConfigPost200Response.parse_obj({
            "id": obj.get("id"),
            "org_id": obj.get("orgId"),
            "is_active": obj.get("isActive"),
            "url": obj.get("url"),
            "encrypted_bind_dn": obj.get("encryptedBindDN"),
            "bind_dniv": obj.get("bindDNIV"),
            "bind_dn_tag": obj.get("bindDNTag"),
            "encrypted_bind_pass": obj.get("encryptedBindPass"),
            "bind_pass_iv": obj.get("bindPassIV"),
            "bind_pass_tag": obj.get("bindPassTag"),
            "search_base": obj.get("searchBase"),
            "encrypted_ca_cert": obj.get("encryptedCACert"),
            "ca_cert_iv": obj.get("caCertIV"),
            "ca_cert_tag": obj.get("caCertTag"),
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt"),
            "group_search_base": obj.get("groupSearchBase") if obj.get("groupSearchBase") is not None else '',
            "group_search_filter": obj.get("groupSearchFilter") if obj.get("groupSearchFilter") is not None else '',
            "search_filter": obj.get("searchFilter") if obj.get("searchFilter") is not None else '',
            "unique_user_attribute": obj.get("uniqueUserAttribute") if obj.get("uniqueUserAttribute") is not None else ''
        })
        return _obj


