# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, constr, validator

class ApiV1OrganizationOrganizationIdPatchRequest(BaseModel):
    """
    ApiV1OrganizationOrganizationIdPatchRequest
    """
    name: Optional[constr(strict=True, max_length=64)] = None
    slug: Optional[constr(strict=True, max_length=64)] = None
    auth_enforced: Optional[StrictBool] = Field(default=None, alias="authEnforced")
    scim_enabled: Optional[StrictBool] = Field(default=None, alias="scimEnabled")
    __properties = ["name", "slug", "authEnforced", "scimEnabled"]

    @validator('slug')
    def slug_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[a-zA-Z0-9-]+$", value):
            raise ValueError(r"must validate the regular expression /^[a-zA-Z0-9-]+$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1OrganizationOrganizationIdPatchRequest:
        """Create an instance of ApiV1OrganizationOrganizationIdPatchRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1OrganizationOrganizationIdPatchRequest:
        """Create an instance of ApiV1OrganizationOrganizationIdPatchRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1OrganizationOrganizationIdPatchRequest.parse_obj(obj)

        _obj = ApiV1OrganizationOrganizationIdPatchRequest.parse_obj({
            "name": obj.get("name"),
            "slug": obj.get("slug"),
            "auth_enforced": obj.get("authEnforced"),
            "scim_enabled": obj.get("scimEnabled")
        })
        return _obj


