# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist

class ApiV1OrganizationOrganizationIdPermissionsGet200ResponseMembership(BaseModel):
    """
    ApiV1OrganizationOrganizationIdPermissionsGet200ResponseMembership
    """
    id: StrictStr = Field(...)
    role: StrictStr = Field(...)
    status: Optional[StrictStr] = 'invited'
    invite_email: Optional[StrictStr] = Field(default=None, alias="inviteEmail")
    created_at: datetime = Field(default=..., alias="createdAt")
    updated_at: datetime = Field(default=..., alias="updatedAt")
    user_id: Optional[StrictStr] = Field(default=None, alias="userId")
    org_id: StrictStr = Field(default=..., alias="orgId")
    role_id: Optional[StrictStr] = Field(default=None, alias="roleId")
    project_favorites: Optional[conlist(StrictStr)] = Field(default=None, alias="projectFavorites")
    is_active: Optional[StrictBool] = Field(default=True, alias="isActive")
    __properties = ["id", "role", "status", "inviteEmail", "createdAt", "updatedAt", "userId", "orgId", "roleId", "projectFavorites", "isActive"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1OrganizationOrganizationIdPermissionsGet200ResponseMembership:
        """Create an instance of ApiV1OrganizationOrganizationIdPermissionsGet200ResponseMembership from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if invite_email (nullable) is None
        # and __fields_set__ contains the field
        if self.invite_email is None and "invite_email" in self.__fields_set__:
            _dict['inviteEmail'] = None

        # set to None if user_id (nullable) is None
        # and __fields_set__ contains the field
        if self.user_id is None and "user_id" in self.__fields_set__:
            _dict['userId'] = None

        # set to None if role_id (nullable) is None
        # and __fields_set__ contains the field
        if self.role_id is None and "role_id" in self.__fields_set__:
            _dict['roleId'] = None

        # set to None if project_favorites (nullable) is None
        # and __fields_set__ contains the field
        if self.project_favorites is None and "project_favorites" in self.__fields_set__:
            _dict['projectFavorites'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1OrganizationOrganizationIdPermissionsGet200ResponseMembership:
        """Create an instance of ApiV1OrganizationOrganizationIdPermissionsGet200ResponseMembership from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1OrganizationOrganizationIdPermissionsGet200ResponseMembership.parse_obj(obj)

        _obj = ApiV1OrganizationOrganizationIdPermissionsGet200ResponseMembership.parse_obj({
            "id": obj.get("id"),
            "role": obj.get("role"),
            "status": obj.get("status") if obj.get("status") is not None else 'invited',
            "invite_email": obj.get("inviteEmail"),
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt"),
            "user_id": obj.get("userId"),
            "org_id": obj.get("orgId"),
            "role_id": obj.get("roleId"),
            "project_favorites": obj.get("projectFavorites"),
            "is_active": obj.get("isActive") if obj.get("isActive") is not None else True
        })
        return _obj


