# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, constr

class ApiV1PkiCaCaIdSignCertificatePostRequest(BaseModel):
    """
    ApiV1PkiCaCaIdSignCertificatePostRequest
    """
    csr: constr(strict=True, min_length=1) = Field(default=..., description="The pem-encoded CSR to sign with the CA to be used for certificate issuance")
    friendly_name: Optional[StrictStr] = Field(default=None, alias="friendlyName", description="A friendly name for the certificate")
    common_name: Optional[constr(strict=True, min_length=1)] = Field(default=None, alias="commonName", description="The common name (CN) for the certificate")
    alt_names: Optional[StrictStr] = Field(default='', alias="altNames", description="A comma-delimited list of Subject Alternative Names (SANs) for the certificate; these can be host names or email addresses.")
    ttl: StrictStr = Field(default=..., description="The time to live for the certificate such as 1m, 1h, 1d, 1y, ...")
    not_before: Optional[StrictStr] = Field(default=None, alias="notBefore", description="The date and time when the certificate becomes valid in YYYY-MM-DDTHH:mm:ss.sssZ format")
    not_after: Optional[StrictStr] = Field(default=None, alias="notAfter", description="The date and time when the certificate expires in YYYY-MM-DDTHH:mm:ss.sssZ format")
    __properties = ["csr", "friendlyName", "commonName", "altNames", "ttl", "notBefore", "notAfter"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1PkiCaCaIdSignCertificatePostRequest:
        """Create an instance of ApiV1PkiCaCaIdSignCertificatePostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1PkiCaCaIdSignCertificatePostRequest:
        """Create an instance of ApiV1PkiCaCaIdSignCertificatePostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1PkiCaCaIdSignCertificatePostRequest.parse_obj(obj)

        _obj = ApiV1PkiCaCaIdSignCertificatePostRequest.parse_obj({
            "csr": obj.get("csr"),
            "friendly_name": obj.get("friendlyName"),
            "common_name": obj.get("commonName"),
            "alt_names": obj.get("altNames") if obj.get("altNames") is not None else '',
            "ttl": obj.get("ttl"),
            "not_before": obj.get("notBefore"),
            "not_after": obj.get("notAfter")
        })
        return _obj


