# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr

class ApiV1PkiCaPost200ResponseCa(BaseModel):
    """
    ApiV1PkiCaPost200ResponseCa
    """
    id: StrictStr = Field(...)
    created_at: datetime = Field(default=..., alias="createdAt")
    updated_at: datetime = Field(default=..., alias="updatedAt")
    parent_ca_id: Optional[StrictStr] = Field(default=None, alias="parentCaId")
    project_id: StrictStr = Field(default=..., alias="projectId")
    type: StrictStr = Field(...)
    status: StrictStr = Field(...)
    friendly_name: StrictStr = Field(default=..., alias="friendlyName")
    organization: StrictStr = Field(...)
    ou: StrictStr = Field(...)
    country: StrictStr = Field(...)
    province: StrictStr = Field(...)
    locality: StrictStr = Field(...)
    common_name: StrictStr = Field(default=..., alias="commonName")
    dn: StrictStr = Field(...)
    serial_number: Optional[StrictStr] = Field(default=None, alias="serialNumber")
    max_path_length: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="maxPathLength")
    key_algorithm: StrictStr = Field(default=..., alias="keyAlgorithm")
    not_before: Optional[datetime] = Field(default=None, alias="notBefore")
    not_after: Optional[datetime] = Field(default=None, alias="notAfter")
    __properties = ["id", "createdAt", "updatedAt", "parentCaId", "projectId", "type", "status", "friendlyName", "organization", "ou", "country", "province", "locality", "commonName", "dn", "serialNumber", "maxPathLength", "keyAlgorithm", "notBefore", "notAfter"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1PkiCaPost200ResponseCa:
        """Create an instance of ApiV1PkiCaPost200ResponseCa from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if parent_ca_id (nullable) is None
        # and __fields_set__ contains the field
        if self.parent_ca_id is None and "parent_ca_id" in self.__fields_set__:
            _dict['parentCaId'] = None

        # set to None if serial_number (nullable) is None
        # and __fields_set__ contains the field
        if self.serial_number is None and "serial_number" in self.__fields_set__:
            _dict['serialNumber'] = None

        # set to None if max_path_length (nullable) is None
        # and __fields_set__ contains the field
        if self.max_path_length is None and "max_path_length" in self.__fields_set__:
            _dict['maxPathLength'] = None

        # set to None if not_before (nullable) is None
        # and __fields_set__ contains the field
        if self.not_before is None and "not_before" in self.__fields_set__:
            _dict['notBefore'] = None

        # set to None if not_after (nullable) is None
        # and __fields_set__ contains the field
        if self.not_after is None and "not_after" in self.__fields_set__:
            _dict['notAfter'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1PkiCaPost200ResponseCa:
        """Create an instance of ApiV1PkiCaPost200ResponseCa from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1PkiCaPost200ResponseCa.parse_obj(obj)

        _obj = ApiV1PkiCaPost200ResponseCa.parse_obj({
            "id": obj.get("id"),
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt"),
            "parent_ca_id": obj.get("parentCaId"),
            "project_id": obj.get("projectId"),
            "type": obj.get("type"),
            "status": obj.get("status"),
            "friendly_name": obj.get("friendlyName"),
            "organization": obj.get("organization"),
            "ou": obj.get("ou"),
            "country": obj.get("country"),
            "province": obj.get("province"),
            "locality": obj.get("locality"),
            "common_name": obj.get("commonName"),
            "dn": obj.get("dn"),
            "serial_number": obj.get("serialNumber"),
            "max_path_length": obj.get("maxPathLength"),
            "key_algorithm": obj.get("keyAlgorithm"),
            "not_before": obj.get("notBefore"),
            "not_after": obj.get("notAfter")
        })
        return _obj


