# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictStr, confloat, conint, validator

class ApiV1PkiCaPostRequest(BaseModel):
    """
    ApiV1PkiCaPostRequest
    """
    project_slug: StrictStr = Field(default=..., alias="projectSlug", description="Slug of the project to create the CA in.")
    type: StrictStr = Field(default=..., description="The type of CA to create")
    friendly_name: Optional[StrictStr] = Field(default=None, alias="friendlyName", description="A friendly name for the CA")
    common_name: StrictStr = Field(default=..., alias="commonName", description="The common name (CN) for the CA")
    organization: StrictStr = Field(default=..., description="The organization (O) for the CA")
    ou: StrictStr = Field(default=..., description="The organization unit (OU) for the CA")
    country: StrictStr = Field(default=..., description="The country name (C) for the CA")
    province: StrictStr = Field(default=..., description="The state of province name for the CA")
    locality: StrictStr = Field(default=..., description="The locality name for the CA")
    not_before: Optional[StrictStr] = Field(default=None, alias="notBefore", description="The date and time when the CA becomes valid in YYYY-MM-DDTHH:mm:ss.sssZ format")
    not_after: Optional[StrictStr] = Field(default=None, alias="notAfter", description="The date and time when the CA expires in YYYY-MM-DDTHH:mm:ss.sssZ format")
    max_path_length: Optional[Union[confloat(ge=-1, strict=True), conint(ge=-1, strict=True)]] = Field(default=-1, alias="maxPathLength", description="The maximum number of intermediate CAs that may follow this CA in the certificate / CA chain. A maxPathLength of -1 implies no path limit on the chain.")
    key_algorithm: Optional[StrictStr] = Field(default='RSA_2048', alias="keyAlgorithm", description="The type of public key algorithm and size, in bits, of the key pair for the CA; when you create an intermediate CA, you must use a key algorithm supported by the parent CA.")
    __properties = ["projectSlug", "type", "friendlyName", "commonName", "organization", "ou", "country", "province", "locality", "notBefore", "notAfter", "maxPathLength", "keyAlgorithm"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('root', 'intermediate'):
            raise ValueError("must be one of enum values ('root', 'intermediate')")
        return value

    @validator('key_algorithm')
    def key_algorithm_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('RSA_2048', 'RSA_4096', 'EC_prime256v1', 'EC_secp384r1'):
            raise ValueError("must be one of enum values ('RSA_2048', 'RSA_4096', 'EC_prime256v1', 'EC_secp384r1')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1PkiCaPostRequest:
        """Create an instance of ApiV1PkiCaPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1PkiCaPostRequest:
        """Create an instance of ApiV1PkiCaPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1PkiCaPostRequest.parse_obj(obj)

        _obj = ApiV1PkiCaPostRequest.parse_obj({
            "project_slug": obj.get("projectSlug"),
            "type": obj.get("type"),
            "friendly_name": obj.get("friendlyName"),
            "common_name": obj.get("commonName"),
            "organization": obj.get("organization"),
            "ou": obj.get("ou"),
            "country": obj.get("country"),
            "province": obj.get("province"),
            "locality": obj.get("locality"),
            "not_before": obj.get("notBefore"),
            "not_after": obj.get("notAfter"),
            "max_path_length": obj.get("maxPathLength") if obj.get("maxPathLength") is not None else -1,
            "key_algorithm": obj.get("keyAlgorithm") if obj.get("keyAlgorithm") is not None else 'RSA_2048'
        })
        return _obj


