# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr

class ApiV1PkiCertificatesSerialNumberGet200ResponseCertificate(BaseModel):
    """
    ApiV1PkiCertificatesSerialNumberGet200ResponseCertificate
    """
    id: StrictStr = Field(...)
    created_at: datetime = Field(default=..., alias="createdAt")
    updated_at: datetime = Field(default=..., alias="updatedAt")
    ca_id: StrictStr = Field(default=..., alias="caId")
    status: StrictStr = Field(...)
    serial_number: StrictStr = Field(default=..., alias="serialNumber")
    friendly_name: StrictStr = Field(default=..., alias="friendlyName")
    common_name: StrictStr = Field(default=..., alias="commonName")
    not_before: datetime = Field(default=..., alias="notBefore")
    not_after: datetime = Field(default=..., alias="notAfter")
    revoked_at: Optional[datetime] = Field(default=None, alias="revokedAt")
    revocation_reason: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="revocationReason")
    alt_names: Optional[StrictStr] = Field(default='', alias="altNames")
    __properties = ["id", "createdAt", "updatedAt", "caId", "status", "serialNumber", "friendlyName", "commonName", "notBefore", "notAfter", "revokedAt", "revocationReason", "altNames"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1PkiCertificatesSerialNumberGet200ResponseCertificate:
        """Create an instance of ApiV1PkiCertificatesSerialNumberGet200ResponseCertificate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if revoked_at (nullable) is None
        # and __fields_set__ contains the field
        if self.revoked_at is None and "revoked_at" in self.__fields_set__:
            _dict['revokedAt'] = None

        # set to None if revocation_reason (nullable) is None
        # and __fields_set__ contains the field
        if self.revocation_reason is None and "revocation_reason" in self.__fields_set__:
            _dict['revocationReason'] = None

        # set to None if alt_names (nullable) is None
        # and __fields_set__ contains the field
        if self.alt_names is None and "alt_names" in self.__fields_set__:
            _dict['altNames'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1PkiCertificatesSerialNumberGet200ResponseCertificate:
        """Create an instance of ApiV1PkiCertificatesSerialNumberGet200ResponseCertificate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1PkiCertificatesSerialNumberGet200ResponseCertificate.parse_obj(obj)

        _obj = ApiV1PkiCertificatesSerialNumberGet200ResponseCertificate.parse_obj({
            "id": obj.get("id"),
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt"),
            "ca_id": obj.get("caId"),
            "status": obj.get("status"),
            "serial_number": obj.get("serialNumber"),
            "friendly_name": obj.get("friendlyName"),
            "common_name": obj.get("commonName"),
            "not_before": obj.get("notBefore"),
            "not_after": obj.get("notAfter"),
            "revoked_at": obj.get("revokedAt"),
            "revocation_reason": obj.get("revocationReason"),
            "alt_names": obj.get("altNames") if obj.get("altNames") is not None else ''
        })
        return _obj


