# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr

class ApiV1RateLimitGet200ResponseRateLimit(BaseModel):
    """
    ApiV1RateLimitGet200ResponseRateLimit
    """
    id: StrictStr = Field(...)
    read_rate_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=600, alias="readRateLimit")
    write_rate_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=200, alias="writeRateLimit")
    secrets_rate_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=60, alias="secretsRateLimit")
    auth_rate_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=60, alias="authRateLimit")
    invite_user_rate_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=30, alias="inviteUserRateLimit")
    mfa_rate_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=20, alias="mfaRateLimit")
    public_endpoint_limit: Optional[Union[StrictFloat, StrictInt]] = Field(default=30, alias="publicEndpointLimit")
    created_at: datetime = Field(default=..., alias="createdAt")
    updated_at: datetime = Field(default=..., alias="updatedAt")
    __properties = ["id", "readRateLimit", "writeRateLimit", "secretsRateLimit", "authRateLimit", "inviteUserRateLimit", "mfaRateLimit", "publicEndpointLimit", "createdAt", "updatedAt"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1RateLimitGet200ResponseRateLimit:
        """Create an instance of ApiV1RateLimitGet200ResponseRateLimit from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1RateLimitGet200ResponseRateLimit:
        """Create an instance of ApiV1RateLimitGet200ResponseRateLimit from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1RateLimitGet200ResponseRateLimit.parse_obj(obj)

        _obj = ApiV1RateLimitGet200ResponseRateLimit.parse_obj({
            "id": obj.get("id"),
            "read_rate_limit": obj.get("readRateLimit") if obj.get("readRateLimit") is not None else 600,
            "write_rate_limit": obj.get("writeRateLimit") if obj.get("writeRateLimit") is not None else 200,
            "secrets_rate_limit": obj.get("secretsRateLimit") if obj.get("secretsRateLimit") is not None else 60,
            "auth_rate_limit": obj.get("authRateLimit") if obj.get("authRateLimit") is not None else 60,
            "invite_user_rate_limit": obj.get("inviteUserRateLimit") if obj.get("inviteUserRateLimit") is not None else 30,
            "mfa_rate_limit": obj.get("mfaRateLimit") if obj.get("mfaRateLimit") is not None else 20,
            "public_endpoint_limit": obj.get("publicEndpointLimit") if obj.get("publicEndpointLimit") is not None else 30,
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt")
        })
        return _obj


