# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, conlist
from infisicalapi_client.models.api_v1_scim_groups_get200_response_resources_inner import ApiV1ScimGroupsGet200ResponseResourcesInner

class ApiV1ScimGroupsGet200Response(BaseModel):
    """
    ApiV1ScimGroupsGet200Response
    """
    resources: conlist(ApiV1ScimGroupsGet200ResponseResourcesInner) = Field(default=..., alias="Resources")
    items_per_page: Union[StrictFloat, StrictInt] = Field(default=..., alias="itemsPerPage")
    schemas: conlist(StrictStr) = Field(...)
    start_index: Union[StrictFloat, StrictInt] = Field(default=..., alias="startIndex")
    total_results: Union[StrictFloat, StrictInt] = Field(default=..., alias="totalResults")
    __properties = ["Resources", "itemsPerPage", "schemas", "startIndex", "totalResults"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1ScimGroupsGet200Response:
        """Create an instance of ApiV1ScimGroupsGet200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in resources (list)
        _items = []
        if self.resources:
            for _item in self.resources:
                if _item:
                    _items.append(_item.to_dict())
            _dict['Resources'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1ScimGroupsGet200Response:
        """Create an instance of ApiV1ScimGroupsGet200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1ScimGroupsGet200Response.parse_obj(obj)

        _obj = ApiV1ScimGroupsGet200Response.parse_obj({
            "resources": [ApiV1ScimGroupsGet200ResponseResourcesInner.from_dict(_item) for _item in obj.get("Resources")] if obj.get("Resources") is not None else None,
            "items_per_page": obj.get("itemsPerPage"),
            "schemas": obj.get("schemas"),
            "start_index": obj.get("startIndex"),
            "total_results": obj.get("totalResults")
        })
        return _obj


