# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist
from infisicalapi_client.models.api_v1_secret_approval_requests_get200_response_approvals_inner_commits_inner import ApiV1SecretApprovalRequestsGet200ResponseApprovalsInnerCommitsInner
from infisicalapi_client.models.api_v1_secret_approval_requests_get200_response_approvals_inner_committer_user import ApiV1SecretApprovalRequestsGet200ResponseApprovalsInnerCommitterUser
from infisicalapi_client.models.api_v1_secret_approval_requests_get200_response_approvals_inner_policy import ApiV1SecretApprovalRequestsGet200ResponseApprovalsInnerPolicy
from infisicalapi_client.models.api_v1_secret_approval_requests_get200_response_approvals_inner_reviewers_inner import ApiV1SecretApprovalRequestsGet200ResponseApprovalsInnerReviewersInner

class ApiV1SecretApprovalRequestsGet200ResponseApprovalsInner(BaseModel):
    """
    ApiV1SecretApprovalRequestsGet200ResponseApprovalsInner
    """
    id: StrictStr = Field(...)
    policy_id: StrictStr = Field(default=..., alias="policyId")
    has_merged: Optional[StrictBool] = Field(default=False, alias="hasMerged")
    status: Optional[StrictStr] = 'open'
    conflicts: Optional[Any] = None
    slug: StrictStr = Field(...)
    folder_id: StrictStr = Field(default=..., alias="folderId")
    created_at: datetime = Field(default=..., alias="createdAt")
    updated_at: datetime = Field(default=..., alias="updatedAt")
    is_replicated: Optional[StrictBool] = Field(default=None, alias="isReplicated")
    committer_user_id: StrictStr = Field(default=..., alias="committerUserId")
    status_changed_by_user_id: Optional[StrictStr] = Field(default=None, alias="statusChangedByUserId")
    bypass_reason: Optional[StrictStr] = Field(default=None, alias="bypassReason")
    policy: ApiV1SecretApprovalRequestsGet200ResponseApprovalsInnerPolicy = Field(...)
    committer_user: ApiV1SecretApprovalRequestsGet200ResponseApprovalsInnerCommitterUser = Field(default=..., alias="committerUser")
    commits: conlist(ApiV1SecretApprovalRequestsGet200ResponseApprovalsInnerCommitsInner) = Field(...)
    environment: StrictStr = Field(...)
    reviewers: conlist(ApiV1SecretApprovalRequestsGet200ResponseApprovalsInnerReviewersInner) = Field(...)
    approvers: conlist(StrictStr) = Field(...)
    __properties = ["id", "policyId", "hasMerged", "status", "conflicts", "slug", "folderId", "createdAt", "updatedAt", "isReplicated", "committerUserId", "statusChangedByUserId", "bypassReason", "policy", "committerUser", "commits", "environment", "reviewers", "approvers"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1SecretApprovalRequestsGet200ResponseApprovalsInner:
        """Create an instance of ApiV1SecretApprovalRequestsGet200ResponseApprovalsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of policy
        if self.policy:
            _dict['policy'] = self.policy.to_dict()
        # override the default output from pydantic by calling `to_dict()` of committer_user
        if self.committer_user:
            _dict['committerUser'] = self.committer_user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in commits (list)
        _items = []
        if self.commits:
            for _item in self.commits:
                if _item:
                    _items.append(_item.to_dict())
            _dict['commits'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in reviewers (list)
        _items = []
        if self.reviewers:
            for _item in self.reviewers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['reviewers'] = _items
        # set to None if conflicts (nullable) is None
        # and __fields_set__ contains the field
        if self.conflicts is None and "conflicts" in self.__fields_set__:
            _dict['conflicts'] = None

        # set to None if is_replicated (nullable) is None
        # and __fields_set__ contains the field
        if self.is_replicated is None and "is_replicated" in self.__fields_set__:
            _dict['isReplicated'] = None

        # set to None if status_changed_by_user_id (nullable) is None
        # and __fields_set__ contains the field
        if self.status_changed_by_user_id is None and "status_changed_by_user_id" in self.__fields_set__:
            _dict['statusChangedByUserId'] = None

        # set to None if bypass_reason (nullable) is None
        # and __fields_set__ contains the field
        if self.bypass_reason is None and "bypass_reason" in self.__fields_set__:
            _dict['bypassReason'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1SecretApprovalRequestsGet200ResponseApprovalsInner:
        """Create an instance of ApiV1SecretApprovalRequestsGet200ResponseApprovalsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1SecretApprovalRequestsGet200ResponseApprovalsInner.parse_obj(obj)

        _obj = ApiV1SecretApprovalRequestsGet200ResponseApprovalsInner.parse_obj({
            "id": obj.get("id"),
            "policy_id": obj.get("policyId"),
            "has_merged": obj.get("hasMerged") if obj.get("hasMerged") is not None else False,
            "status": obj.get("status") if obj.get("status") is not None else 'open',
            "conflicts": obj.get("conflicts"),
            "slug": obj.get("slug"),
            "folder_id": obj.get("folderId"),
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt"),
            "is_replicated": obj.get("isReplicated"),
            "committer_user_id": obj.get("committerUserId"),
            "status_changed_by_user_id": obj.get("statusChangedByUserId"),
            "bypass_reason": obj.get("bypassReason"),
            "policy": ApiV1SecretApprovalRequestsGet200ResponseApprovalsInnerPolicy.from_dict(obj.get("policy")) if obj.get("policy") is not None else None,
            "committer_user": ApiV1SecretApprovalRequestsGet200ResponseApprovalsInnerCommitterUser.from_dict(obj.get("committerUser")) if obj.get("committerUser") is not None else None,
            "commits": [ApiV1SecretApprovalRequestsGet200ResponseApprovalsInnerCommitsInner.from_dict(_item) for _item in obj.get("commits")] if obj.get("commits") is not None else None,
            "environment": obj.get("environment"),
            "reviewers": [ApiV1SecretApprovalRequestsGet200ResponseApprovalsInnerReviewersInner.from_dict(_item) for _item in obj.get("reviewers")] if obj.get("reviewers") is not None else None,
            "approvers": obj.get("approvers")
        })
        return _obj


