# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, conlist
from infisicalapi_client.models.api_v1_secret_snapshot_secret_snapshot_id_get200_response_secret_snapshot_secret_versions_inner_tags_inner import ApiV1SecretSnapshotSecretSnapshotIdGet200ResponseSecretSnapshotSecretVersionsInnerTagsInner

class ApiV1SecretApprovalRequestsIdGet200ResponseApprovalCommitsInnerSecretVersion(BaseModel):
    """
    ApiV1SecretApprovalRequestsIdGet200ResponseApprovalCommitsInnerSecretVersion
    """
    id: StrictStr = Field(...)
    version: Union[StrictFloat, StrictInt] = Field(...)
    secret_key: StrictStr = Field(default=..., alias="secretKey")
    secret_value: Optional[StrictStr] = Field(default=None, alias="secretValue")
    secret_comment: Optional[StrictStr] = Field(default=None, alias="secretComment")
    tags: Optional[conlist(ApiV1SecretSnapshotSecretSnapshotIdGet200ResponseSecretSnapshotSecretVersionsInnerTagsInner)] = None
    __properties = ["id", "version", "secretKey", "secretValue", "secretComment", "tags"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1SecretApprovalRequestsIdGet200ResponseApprovalCommitsInnerSecretVersion:
        """Create an instance of ApiV1SecretApprovalRequestsIdGet200ResponseApprovalCommitsInnerSecretVersion from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item in self.tags:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tags'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1SecretApprovalRequestsIdGet200ResponseApprovalCommitsInnerSecretVersion:
        """Create an instance of ApiV1SecretApprovalRequestsIdGet200ResponseApprovalCommitsInnerSecretVersion from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1SecretApprovalRequestsIdGet200ResponseApprovalCommitsInnerSecretVersion.parse_obj(obj)

        _obj = ApiV1SecretApprovalRequestsIdGet200ResponseApprovalCommitsInnerSecretVersion.parse_obj({
            "id": obj.get("id"),
            "version": obj.get("version"),
            "secret_key": obj.get("secretKey"),
            "secret_value": obj.get("secretValue"),
            "secret_comment": obj.get("secretComment"),
            "tags": [ApiV1SecretSnapshotSecretSnapshotIdGet200ResponseSecretSnapshotSecretVersionsInnerTagsInner.from_dict(_item) for _item in obj.get("tags")] if obj.get("tags") is not None else None
        })
        return _obj


