# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, conlist
from infisicalapi_client.models.api_v1_secret_approvals_get200_response_approvals_inner_environment import ApiV1SecretApprovalsGet200ResponseApprovalsInnerEnvironment
from infisicalapi_client.models.api_v1_secret_approvals_get200_response_approvals_inner_user_approvers_inner import ApiV1SecretApprovalsGet200ResponseApprovalsInnerUserApproversInner

class ApiV1SecretApprovalsGet200ResponseApprovalsInner(BaseModel):
    """
    ApiV1SecretApprovalsGet200ResponseApprovalsInner
    """
    id: StrictStr = Field(...)
    name: StrictStr = Field(...)
    secret_path: Optional[StrictStr] = Field(default=None, alias="secretPath")
    approvals: Optional[Union[StrictFloat, StrictInt]] = 1
    env_id: StrictStr = Field(default=..., alias="envId")
    created_at: datetime = Field(default=..., alias="createdAt")
    updated_at: datetime = Field(default=..., alias="updatedAt")
    enforcement_level: Optional[StrictStr] = Field(default='hard', alias="enforcementLevel")
    environment: ApiV1SecretApprovalsGet200ResponseApprovalsInnerEnvironment = Field(...)
    project_id: StrictStr = Field(default=..., alias="projectId")
    user_approvers: conlist(ApiV1SecretApprovalsGet200ResponseApprovalsInnerUserApproversInner) = Field(default=..., alias="userApprovers")
    __properties = ["id", "name", "secretPath", "approvals", "envId", "createdAt", "updatedAt", "enforcementLevel", "environment", "projectId", "userApprovers"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1SecretApprovalsGet200ResponseApprovalsInner:
        """Create an instance of ApiV1SecretApprovalsGet200ResponseApprovalsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of environment
        if self.environment:
            _dict['environment'] = self.environment.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in user_approvers (list)
        _items = []
        if self.user_approvers:
            for _item in self.user_approvers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['userApprovers'] = _items
        # set to None if secret_path (nullable) is None
        # and __fields_set__ contains the field
        if self.secret_path is None and "secret_path" in self.__fields_set__:
            _dict['secretPath'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1SecretApprovalsGet200ResponseApprovalsInner:
        """Create an instance of ApiV1SecretApprovalsGet200ResponseApprovalsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1SecretApprovalsGet200ResponseApprovalsInner.parse_obj(obj)

        _obj = ApiV1SecretApprovalsGet200ResponseApprovalsInner.parse_obj({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "secret_path": obj.get("secretPath"),
            "approvals": obj.get("approvals") if obj.get("approvals") is not None else 1,
            "env_id": obj.get("envId"),
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt"),
            "enforcement_level": obj.get("enforcementLevel") if obj.get("enforcementLevel") is not None else 'hard',
            "environment": ApiV1SecretApprovalsGet200ResponseApprovalsInnerEnvironment.from_dict(obj.get("environment")) if obj.get("environment") is not None else None,
            "project_id": obj.get("projectId"),
            "user_approvers": [ApiV1SecretApprovalsGet200ResponseApprovalsInnerUserApproversInner.from_dict(_item) for _item in obj.get("userApprovers")] if obj.get("userApprovers") is not None else None
        })
        return _obj


