# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional, Union
from pydantic import BaseModel, Field, StrictStr, confloat, conint, conlist, validator

class ApiV1SecretApprovalsPostRequest(BaseModel):
    """
    ApiV1SecretApprovalsPostRequest
    """
    workspace_id: StrictStr = Field(default=..., alias="workspaceId")
    name: Optional[StrictStr] = None
    environment: StrictStr = Field(...)
    secret_path: Optional[StrictStr] = Field(default='/', alias="secretPath")
    approvers: conlist(StrictStr, min_items=1) = Field(...)
    approvals: Optional[Union[confloat(ge=1, strict=True), conint(ge=1, strict=True)]] = 1
    enforcement_level: Optional[StrictStr] = Field(default='hard', alias="enforcementLevel")
    __properties = ["workspaceId", "name", "environment", "secretPath", "approvers", "approvals", "enforcementLevel"]

    @validator('enforcement_level')
    def enforcement_level_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('hard', 'soft'):
            raise ValueError("must be one of enum values ('hard', 'soft')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1SecretApprovalsPostRequest:
        """Create an instance of ApiV1SecretApprovalsPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if secret_path (nullable) is None
        # and __fields_set__ contains the field
        if self.secret_path is None and "secret_path" in self.__fields_set__:
            _dict['secretPath'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1SecretApprovalsPostRequest:
        """Create an instance of ApiV1SecretApprovalsPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1SecretApprovalsPostRequest.parse_obj(obj)

        _obj = ApiV1SecretApprovalsPostRequest.parse_obj({
            "workspace_id": obj.get("workspaceId"),
            "name": obj.get("name"),
            "environment": obj.get("environment"),
            "secret_path": obj.get("secretPath") if obj.get("secretPath") is not None else '/',
            "approvers": obj.get("approvers"),
            "approvals": obj.get("approvals") if obj.get("approvals") is not None else 1,
            "enforcement_level": obj.get("enforcementLevel") if obj.get("enforcementLevel") is not None else 'hard'
        })
        return _obj


