# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional, Union
from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from infisicalapi_client.models.api_v1_secret_imports_get200_response_secret_imports_inner_import_env import ApiV1SecretImportsGet200ResponseSecretImportsInnerImportEnv

class ApiV1SecretImportsGet200ResponseSecretImportsInner(BaseModel):
    """
    ApiV1SecretImportsGet200ResponseSecretImportsInner
    """
    id: StrictStr = Field(...)
    version: Optional[Union[StrictFloat, StrictInt]] = 1
    import_path: StrictStr = Field(default=..., alias="importPath")
    position: Union[StrictFloat, StrictInt] = Field(...)
    created_at: datetime = Field(default=..., alias="createdAt")
    updated_at: datetime = Field(default=..., alias="updatedAt")
    folder_id: StrictStr = Field(default=..., alias="folderId")
    is_replication: Optional[StrictBool] = Field(default=False, alias="isReplication")
    is_replication_success: Optional[StrictBool] = Field(default=None, alias="isReplicationSuccess")
    replication_status: Optional[StrictStr] = Field(default=None, alias="replicationStatus")
    last_replicated: Optional[datetime] = Field(default=None, alias="lastReplicated")
    is_reserved: Optional[StrictBool] = Field(default=False, alias="isReserved")
    import_env: ApiV1SecretImportsGet200ResponseSecretImportsInnerImportEnv = Field(default=..., alias="importEnv")
    __properties = ["id", "version", "importPath", "position", "createdAt", "updatedAt", "folderId", "isReplication", "isReplicationSuccess", "replicationStatus", "lastReplicated", "isReserved", "importEnv"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1SecretImportsGet200ResponseSecretImportsInner:
        """Create an instance of ApiV1SecretImportsGet200ResponseSecretImportsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of import_env
        if self.import_env:
            _dict['importEnv'] = self.import_env.to_dict()
        # set to None if version (nullable) is None
        # and __fields_set__ contains the field
        if self.version is None and "version" in self.__fields_set__:
            _dict['version'] = None

        # set to None if is_replication (nullable) is None
        # and __fields_set__ contains the field
        if self.is_replication is None and "is_replication" in self.__fields_set__:
            _dict['isReplication'] = None

        # set to None if is_replication_success (nullable) is None
        # and __fields_set__ contains the field
        if self.is_replication_success is None and "is_replication_success" in self.__fields_set__:
            _dict['isReplicationSuccess'] = None

        # set to None if replication_status (nullable) is None
        # and __fields_set__ contains the field
        if self.replication_status is None and "replication_status" in self.__fields_set__:
            _dict['replicationStatus'] = None

        # set to None if last_replicated (nullable) is None
        # and __fields_set__ contains the field
        if self.last_replicated is None and "last_replicated" in self.__fields_set__:
            _dict['lastReplicated'] = None

        # set to None if is_reserved (nullable) is None
        # and __fields_set__ contains the field
        if self.is_reserved is None and "is_reserved" in self.__fields_set__:
            _dict['isReserved'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1SecretImportsGet200ResponseSecretImportsInner:
        """Create an instance of ApiV1SecretImportsGet200ResponseSecretImportsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1SecretImportsGet200ResponseSecretImportsInner.parse_obj(obj)

        _obj = ApiV1SecretImportsGet200ResponseSecretImportsInner.parse_obj({
            "id": obj.get("id"),
            "version": obj.get("version") if obj.get("version") is not None else 1,
            "import_path": obj.get("importPath"),
            "position": obj.get("position"),
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt"),
            "folder_id": obj.get("folderId"),
            "is_replication": obj.get("isReplication") if obj.get("isReplication") is not None else False,
            "is_replication_success": obj.get("isReplicationSuccess"),
            "replication_status": obj.get("replicationStatus"),
            "last_replicated": obj.get("lastReplicated"),
            "is_reserved": obj.get("isReserved") if obj.get("isReserved") is not None else False,
            "import_env": ApiV1SecretImportsGet200ResponseSecretImportsInnerImportEnv.from_dict(obj.get("importEnv")) if obj.get("importEnv") is not None else None
        })
        return _obj


