# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from infisicalapi_client.models.api_v1_secret_approvals_get200_response_approvals_inner_environment import ApiV1SecretApprovalsGet200ResponseApprovalsInnerEnvironment
from infisicalapi_client.models.api_v1_secret_secret_id_secret_versions_get200_response_secret_versions_inner import ApiV1SecretSecretIdSecretVersionsGet200ResponseSecretVersionsInner

class ApiV1SecretImportsSecretsRawGet200ResponseSecretsInner(BaseModel):
    """
    ApiV1SecretImportsSecretsRawGet200ResponseSecretsInner
    """
    secret_path: StrictStr = Field(default=..., alias="secretPath")
    environment: StrictStr = Field(...)
    environment_info: ApiV1SecretApprovalsGet200ResponseApprovalsInnerEnvironment = Field(default=..., alias="environmentInfo")
    folder_id: Optional[StrictStr] = Field(default=None, alias="folderId")
    secrets: conlist(ApiV1SecretSecretIdSecretVersionsGet200ResponseSecretVersionsInner) = Field(...)
    __properties = ["secretPath", "environment", "environmentInfo", "folderId", "secrets"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1SecretImportsSecretsRawGet200ResponseSecretsInner:
        """Create an instance of ApiV1SecretImportsSecretsRawGet200ResponseSecretsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of environment_info
        if self.environment_info:
            _dict['environmentInfo'] = self.environment_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in secrets (list)
        _items = []
        if self.secrets:
            for _item in self.secrets:
                if _item:
                    _items.append(_item.to_dict())
            _dict['secrets'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1SecretImportsSecretsRawGet200ResponseSecretsInner:
        """Create an instance of ApiV1SecretImportsSecretsRawGet200ResponseSecretsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1SecretImportsSecretsRawGet200ResponseSecretsInner.parse_obj(obj)

        _obj = ApiV1SecretImportsSecretsRawGet200ResponseSecretsInner.parse_obj({
            "secret_path": obj.get("secretPath"),
            "environment": obj.get("environment"),
            "environment_info": ApiV1SecretApprovalsGet200ResponseApprovalsInnerEnvironment.from_dict(obj.get("environmentInfo")) if obj.get("environmentInfo") is not None else None,
            "folder_id": obj.get("folderId"),
            "secrets": [ApiV1SecretSecretIdSecretVersionsGet200ResponseSecretVersionsInner.from_dict(_item) for _item in obj.get("secrets")] if obj.get("secrets") is not None else None
        })
        return _obj


