# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, conlist
from infisicalapi_client.models.api_v1_secret_approvals_get200_response_approvals_inner_environment import ApiV1SecretApprovalsGet200ResponseApprovalsInnerEnvironment
from infisicalapi_client.models.api_v1_secret_rotations_post200_response_secret_rotation_outputs_inner import ApiV1SecretRotationsPost200ResponseSecretRotationOutputsInner

class ApiV1SecretRotationsPost200ResponseSecretRotation(BaseModel):
    """
    ApiV1SecretRotationsPost200ResponseSecretRotation
    """
    id: StrictStr = Field(...)
    provider: StrictStr = Field(...)
    secret_path: StrictStr = Field(default=..., alias="secretPath")
    interval: Union[StrictFloat, StrictInt] = Field(...)
    last_rotated_at: Optional[datetime] = Field(default=None, alias="lastRotatedAt")
    status: Optional[StrictStr] = None
    status_message: Optional[StrictStr] = Field(default=None, alias="statusMessage")
    encrypted_data: Optional[StrictStr] = Field(default=None, alias="encryptedData")
    encrypted_data_iv: Optional[StrictStr] = Field(default=None, alias="encryptedDataIV")
    encrypted_data_tag: Optional[StrictStr] = Field(default=None, alias="encryptedDataTag")
    algorithm: Optional[StrictStr] = None
    key_encoding: Optional[StrictStr] = Field(default=None, alias="keyEncoding")
    env_id: StrictStr = Field(default=..., alias="envId")
    created_at: datetime = Field(default=..., alias="createdAt")
    updated_at: datetime = Field(default=..., alias="updatedAt")
    environment: ApiV1SecretApprovalsGet200ResponseApprovalsInnerEnvironment = Field(...)
    outputs: conlist(ApiV1SecretRotationsPost200ResponseSecretRotationOutputsInner) = Field(...)
    __properties = ["id", "provider", "secretPath", "interval", "lastRotatedAt", "status", "statusMessage", "encryptedData", "encryptedDataIV", "encryptedDataTag", "algorithm", "keyEncoding", "envId", "createdAt", "updatedAt", "environment", "outputs"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1SecretRotationsPost200ResponseSecretRotation:
        """Create an instance of ApiV1SecretRotationsPost200ResponseSecretRotation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of environment
        if self.environment:
            _dict['environment'] = self.environment.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in outputs (list)
        _items = []
        if self.outputs:
            for _item in self.outputs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['outputs'] = _items
        # set to None if last_rotated_at (nullable) is None
        # and __fields_set__ contains the field
        if self.last_rotated_at is None and "last_rotated_at" in self.__fields_set__:
            _dict['lastRotatedAt'] = None

        # set to None if status (nullable) is None
        # and __fields_set__ contains the field
        if self.status is None and "status" in self.__fields_set__:
            _dict['status'] = None

        # set to None if status_message (nullable) is None
        # and __fields_set__ contains the field
        if self.status_message is None and "status_message" in self.__fields_set__:
            _dict['statusMessage'] = None

        # set to None if encrypted_data (nullable) is None
        # and __fields_set__ contains the field
        if self.encrypted_data is None and "encrypted_data" in self.__fields_set__:
            _dict['encryptedData'] = None

        # set to None if encrypted_data_iv (nullable) is None
        # and __fields_set__ contains the field
        if self.encrypted_data_iv is None and "encrypted_data_iv" in self.__fields_set__:
            _dict['encryptedDataIV'] = None

        # set to None if encrypted_data_tag (nullable) is None
        # and __fields_set__ contains the field
        if self.encrypted_data_tag is None and "encrypted_data_tag" in self.__fields_set__:
            _dict['encryptedDataTag'] = None

        # set to None if algorithm (nullable) is None
        # and __fields_set__ contains the field
        if self.algorithm is None and "algorithm" in self.__fields_set__:
            _dict['algorithm'] = None

        # set to None if key_encoding (nullable) is None
        # and __fields_set__ contains the field
        if self.key_encoding is None and "key_encoding" in self.__fields_set__:
            _dict['keyEncoding'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1SecretRotationsPost200ResponseSecretRotation:
        """Create an instance of ApiV1SecretRotationsPost200ResponseSecretRotation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1SecretRotationsPost200ResponseSecretRotation.parse_obj(obj)

        _obj = ApiV1SecretRotationsPost200ResponseSecretRotation.parse_obj({
            "id": obj.get("id"),
            "provider": obj.get("provider"),
            "secret_path": obj.get("secretPath"),
            "interval": obj.get("interval"),
            "last_rotated_at": obj.get("lastRotatedAt"),
            "status": obj.get("status"),
            "status_message": obj.get("statusMessage"),
            "encrypted_data": obj.get("encryptedData"),
            "encrypted_data_iv": obj.get("encryptedDataIV"),
            "encrypted_data_tag": obj.get("encryptedDataTag"),
            "algorithm": obj.get("algorithm"),
            "key_encoding": obj.get("keyEncoding"),
            "env_id": obj.get("envId"),
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt"),
            "environment": ApiV1SecretApprovalsGet200ResponseApprovalsInnerEnvironment.from_dict(obj.get("environment")) if obj.get("environment") is not None else None,
            "outputs": [ApiV1SecretRotationsPost200ResponseSecretRotationOutputsInner.from_dict(_item) for _item in obj.get("outputs")] if obj.get("outputs") is not None else None
        })
        return _obj


