# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional, Union
from pydantic import BaseModel, Field, StrictStr, confloat, conint

class ApiV1SecretRotationsPostRequest(BaseModel):
    """
    ApiV1SecretRotationsPostRequest
    """
    workspace_id: StrictStr = Field(default=..., alias="workspaceId")
    secret_path: StrictStr = Field(default=..., alias="secretPath")
    environment: StrictStr = Field(...)
    interval: Union[confloat(ge=1, strict=True), conint(ge=1, strict=True)] = Field(...)
    provider: StrictStr = Field(...)
    custom_provider: Optional[StrictStr] = Field(default=None, alias="customProvider")
    inputs: Dict[str, Any] = Field(...)
    outputs: Dict[str, StrictStr] = Field(...)
    __properties = ["workspaceId", "secretPath", "environment", "interval", "provider", "customProvider", "inputs", "outputs"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1SecretRotationsPostRequest:
        """Create an instance of ApiV1SecretRotationsPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1SecretRotationsPostRequest:
        """Create an instance of ApiV1SecretRotationsPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1SecretRotationsPostRequest.parse_obj(obj)

        _obj = ApiV1SecretRotationsPostRequest.parse_obj({
            "workspace_id": obj.get("workspaceId"),
            "secret_path": obj.get("secretPath"),
            "environment": obj.get("environment"),
            "interval": obj.get("interval"),
            "provider": obj.get("provider"),
            "custom_provider": obj.get("customProvider"),
            "inputs": obj.get("inputs"),
            "outputs": obj.get("outputs")
        })
        return _obj


