# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr

class ApiV1SecretSharingGet200ResponseSecretsInner(BaseModel):
    """
    ApiV1SecretSharingGet200ResponseSecretsInner
    """
    id: StrictStr = Field(...)
    encrypted_value: StrictStr = Field(default=..., alias="encryptedValue")
    iv: StrictStr = Field(...)
    tag: StrictStr = Field(...)
    hashed_hex: StrictStr = Field(default=..., alias="hashedHex")
    expires_at: datetime = Field(default=..., alias="expiresAt")
    user_id: Optional[StrictStr] = Field(default=None, alias="userId")
    org_id: Optional[StrictStr] = Field(default=None, alias="orgId")
    created_at: datetime = Field(default=..., alias="createdAt")
    updated_at: datetime = Field(default=..., alias="updatedAt")
    expires_after_views: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="expiresAfterViews")
    access_type: Optional[StrictStr] = Field(default='anyone', alias="accessType")
    name: Optional[StrictStr] = None
    last_viewed_at: Optional[datetime] = Field(default=None, alias="lastViewedAt")
    __properties = ["id", "encryptedValue", "iv", "tag", "hashedHex", "expiresAt", "userId", "orgId", "createdAt", "updatedAt", "expiresAfterViews", "accessType", "name", "lastViewedAt"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1SecretSharingGet200ResponseSecretsInner:
        """Create an instance of ApiV1SecretSharingGet200ResponseSecretsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if user_id (nullable) is None
        # and __fields_set__ contains the field
        if self.user_id is None and "user_id" in self.__fields_set__:
            _dict['userId'] = None

        # set to None if org_id (nullable) is None
        # and __fields_set__ contains the field
        if self.org_id is None and "org_id" in self.__fields_set__:
            _dict['orgId'] = None

        # set to None if expires_after_views (nullable) is None
        # and __fields_set__ contains the field
        if self.expires_after_views is None and "expires_after_views" in self.__fields_set__:
            _dict['expiresAfterViews'] = None

        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if last_viewed_at (nullable) is None
        # and __fields_set__ contains the field
        if self.last_viewed_at is None and "last_viewed_at" in self.__fields_set__:
            _dict['lastViewedAt'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1SecretSharingGet200ResponseSecretsInner:
        """Create an instance of ApiV1SecretSharingGet200ResponseSecretsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1SecretSharingGet200ResponseSecretsInner.parse_obj(obj)

        _obj = ApiV1SecretSharingGet200ResponseSecretsInner.parse_obj({
            "id": obj.get("id"),
            "encrypted_value": obj.get("encryptedValue"),
            "iv": obj.get("iv"),
            "tag": obj.get("tag"),
            "hashed_hex": obj.get("hashedHex"),
            "expires_at": obj.get("expiresAt"),
            "user_id": obj.get("userId"),
            "org_id": obj.get("orgId"),
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt"),
            "expires_after_views": obj.get("expiresAfterViews"),
            "access_type": obj.get("accessType") if obj.get("accessType") is not None else 'anyone',
            "name": obj.get("name"),
            "last_viewed_at": obj.get("lastViewedAt")
        })
        return _obj


