# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, validator

class ApiV1SsoConfigPatchRequest(BaseModel):
    """
    ApiV1SsoConfigPatchRequest
    """
    auth_provider: Optional[StrictStr] = Field(default=None, alias="authProvider")
    is_active: Optional[StrictBool] = Field(default=None, alias="isActive")
    entry_point: Optional[StrictStr] = Field(default=None, alias="entryPoint")
    issuer: Optional[StrictStr] = None
    cert: Optional[StrictStr] = None
    organization_id: StrictStr = Field(default=..., alias="organizationId")
    __properties = ["authProvider", "isActive", "entryPoint", "issuer", "cert", "organizationId"]

    @validator('auth_provider')
    def auth_provider_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('okta-saml', 'azure-saml', 'jumpcloud-saml', 'google-saml', 'keycloak-saml'):
            raise ValueError("must be one of enum values ('okta-saml', 'azure-saml', 'jumpcloud-saml', 'google-saml', 'keycloak-saml')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1SsoConfigPatchRequest:
        """Create an instance of ApiV1SsoConfigPatchRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1SsoConfigPatchRequest:
        """Create an instance of ApiV1SsoConfigPatchRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1SsoConfigPatchRequest.parse_obj(obj)

        _obj = ApiV1SsoConfigPatchRequest.parse_obj({
            "auth_provider": obj.get("authProvider"),
            "is_active": obj.get("isActive"),
            "entry_point": obj.get("entryPoint"),
            "issuer": obj.get("issuer"),
            "cert": obj.get("cert"),
            "organization_id": obj.get("organizationId")
        })
        return _obj


