# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr

class ApiV1SsoConfigPost200Response(BaseModel):
    """
    ApiV1SsoConfigPost200Response
    """
    id: StrictStr = Field(...)
    auth_provider: StrictStr = Field(default=..., alias="authProvider")
    is_active: StrictBool = Field(default=..., alias="isActive")
    encrypted_entry_point: Optional[StrictStr] = Field(default=None, alias="encryptedEntryPoint")
    entry_point_iv: Optional[StrictStr] = Field(default=None, alias="entryPointIV")
    entry_point_tag: Optional[StrictStr] = Field(default=None, alias="entryPointTag")
    encrypted_issuer: Optional[StrictStr] = Field(default=None, alias="encryptedIssuer")
    issuer_tag: Optional[StrictStr] = Field(default=None, alias="issuerTag")
    issuer_iv: Optional[StrictStr] = Field(default=None, alias="issuerIV")
    encrypted_cert: Optional[StrictStr] = Field(default=None, alias="encryptedCert")
    cert_iv: Optional[StrictStr] = Field(default=None, alias="certIV")
    cert_tag: Optional[StrictStr] = Field(default=None, alias="certTag")
    created_at: datetime = Field(default=..., alias="createdAt")
    updated_at: datetime = Field(default=..., alias="updatedAt")
    org_id: StrictStr = Field(default=..., alias="orgId")
    last_used: Optional[datetime] = Field(default=None, alias="lastUsed")
    __properties = ["id", "authProvider", "isActive", "encryptedEntryPoint", "entryPointIV", "entryPointTag", "encryptedIssuer", "issuerTag", "issuerIV", "encryptedCert", "certIV", "certTag", "createdAt", "updatedAt", "orgId", "lastUsed"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1SsoConfigPost200Response:
        """Create an instance of ApiV1SsoConfigPost200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if encrypted_entry_point (nullable) is None
        # and __fields_set__ contains the field
        if self.encrypted_entry_point is None and "encrypted_entry_point" in self.__fields_set__:
            _dict['encryptedEntryPoint'] = None

        # set to None if entry_point_iv (nullable) is None
        # and __fields_set__ contains the field
        if self.entry_point_iv is None and "entry_point_iv" in self.__fields_set__:
            _dict['entryPointIV'] = None

        # set to None if entry_point_tag (nullable) is None
        # and __fields_set__ contains the field
        if self.entry_point_tag is None and "entry_point_tag" in self.__fields_set__:
            _dict['entryPointTag'] = None

        # set to None if encrypted_issuer (nullable) is None
        # and __fields_set__ contains the field
        if self.encrypted_issuer is None and "encrypted_issuer" in self.__fields_set__:
            _dict['encryptedIssuer'] = None

        # set to None if issuer_tag (nullable) is None
        # and __fields_set__ contains the field
        if self.issuer_tag is None and "issuer_tag" in self.__fields_set__:
            _dict['issuerTag'] = None

        # set to None if issuer_iv (nullable) is None
        # and __fields_set__ contains the field
        if self.issuer_iv is None and "issuer_iv" in self.__fields_set__:
            _dict['issuerIV'] = None

        # set to None if encrypted_cert (nullable) is None
        # and __fields_set__ contains the field
        if self.encrypted_cert is None and "encrypted_cert" in self.__fields_set__:
            _dict['encryptedCert'] = None

        # set to None if cert_iv (nullable) is None
        # and __fields_set__ contains the field
        if self.cert_iv is None and "cert_iv" in self.__fields_set__:
            _dict['certIV'] = None

        # set to None if cert_tag (nullable) is None
        # and __fields_set__ contains the field
        if self.cert_tag is None and "cert_tag" in self.__fields_set__:
            _dict['certTag'] = None

        # set to None if last_used (nullable) is None
        # and __fields_set__ contains the field
        if self.last_used is None and "last_used" in self.__fields_set__:
            _dict['lastUsed'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1SsoConfigPost200Response:
        """Create an instance of ApiV1SsoConfigPost200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1SsoConfigPost200Response.parse_obj(obj)

        _obj = ApiV1SsoConfigPost200Response.parse_obj({
            "id": obj.get("id"),
            "auth_provider": obj.get("authProvider"),
            "is_active": obj.get("isActive"),
            "encrypted_entry_point": obj.get("encryptedEntryPoint"),
            "entry_point_iv": obj.get("entryPointIV"),
            "entry_point_tag": obj.get("entryPointTag"),
            "encrypted_issuer": obj.get("encryptedIssuer"),
            "issuer_tag": obj.get("issuerTag"),
            "issuer_iv": obj.get("issuerIV"),
            "encrypted_cert": obj.get("encryptedCert"),
            "cert_iv": obj.get("certIV"),
            "cert_tag": obj.get("certTag"),
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt"),
            "org_id": obj.get("orgId"),
            "last_used": obj.get("lastUsed")
        })
        return _obj


