# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, validator

class ApiV1SsoOidcConfigPostRequest(BaseModel):
    """
    ApiV1SsoOidcConfigPostRequest
    """
    allowed_email_domains: Optional[StrictStr] = Field(default='', alias="allowedEmailDomains")
    configuration_type: StrictStr = Field(default=..., alias="configurationType")
    issuer: Optional[StrictStr] = ''
    discovery_url: Optional[StrictStr] = Field(default='', alias="discoveryURL")
    authorization_endpoint: Optional[StrictStr] = Field(default='', alias="authorizationEndpoint")
    jwks_uri: Optional[StrictStr] = Field(default='', alias="jwksUri")
    token_endpoint: Optional[StrictStr] = Field(default='', alias="tokenEndpoint")
    userinfo_endpoint: Optional[StrictStr] = Field(default='', alias="userinfoEndpoint")
    client_id: StrictStr = Field(default=..., alias="clientId")
    client_secret: StrictStr = Field(default=..., alias="clientSecret")
    is_active: StrictBool = Field(default=..., alias="isActive")
    org_slug: StrictStr = Field(default=..., alias="orgSlug")
    __properties = ["allowedEmailDomains", "configurationType", "issuer", "discoveryURL", "authorizationEndpoint", "jwksUri", "tokenEndpoint", "userinfoEndpoint", "clientId", "clientSecret", "isActive", "orgSlug"]

    @validator('configuration_type')
    def configuration_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('custom', 'discoveryURL'):
            raise ValueError("must be one of enum values ('custom', 'discoveryURL')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1SsoOidcConfigPostRequest:
        """Create an instance of ApiV1SsoOidcConfigPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1SsoOidcConfigPostRequest:
        """Create an instance of ApiV1SsoOidcConfigPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1SsoOidcConfigPostRequest.parse_obj(obj)

        _obj = ApiV1SsoOidcConfigPostRequest.parse_obj({
            "allowed_email_domains": obj.get("allowedEmailDomains") if obj.get("allowedEmailDomains") is not None else '',
            "configuration_type": obj.get("configurationType"),
            "issuer": obj.get("issuer") if obj.get("issuer") is not None else '',
            "discovery_url": obj.get("discoveryURL") if obj.get("discoveryURL") is not None else '',
            "authorization_endpoint": obj.get("authorizationEndpoint") if obj.get("authorizationEndpoint") is not None else '',
            "jwks_uri": obj.get("jwksUri") if obj.get("jwksUri") is not None else '',
            "token_endpoint": obj.get("tokenEndpoint") if obj.get("tokenEndpoint") is not None else '',
            "userinfo_endpoint": obj.get("userinfoEndpoint") if obj.get("userinfoEndpoint") is not None else '',
            "client_id": obj.get("clientId"),
            "client_secret": obj.get("clientSecret"),
            "is_active": obj.get("isActive"),
            "org_slug": obj.get("orgSlug")
        })
        return _obj


