# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr
from infisicalapi_client.models.api_v1_secret_approvals_get200_response_approvals_inner_environment import ApiV1SecretApprovalsGet200ResponseApprovalsInnerEnvironment

class ApiV1WebhooksPost200ResponseWebhook(BaseModel):
    """
    ApiV1WebhooksPost200ResponseWebhook
    """
    id: StrictStr = Field(...)
    secret_path: Optional[StrictStr] = Field(default='/', alias="secretPath")
    last_status: Optional[StrictStr] = Field(default=None, alias="lastStatus")
    last_run_error_message: Optional[StrictStr] = Field(default=None, alias="lastRunErrorMessage")
    is_disabled: Optional[StrictBool] = Field(default=False, alias="isDisabled")
    created_at: datetime = Field(default=..., alias="createdAt")
    updated_at: datetime = Field(default=..., alias="updatedAt")
    env_id: StrictStr = Field(default=..., alias="envId")
    type: Optional[StrictStr] = 'general'
    project_id: StrictStr = Field(default=..., alias="projectId")
    environment: ApiV1SecretApprovalsGet200ResponseApprovalsInnerEnvironment = Field(...)
    __properties = ["id", "secretPath", "lastStatus", "lastRunErrorMessage", "isDisabled", "createdAt", "updatedAt", "envId", "type", "projectId", "environment"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1WebhooksPost200ResponseWebhook:
        """Create an instance of ApiV1WebhooksPost200ResponseWebhook from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of environment
        if self.environment:
            _dict['environment'] = self.environment.to_dict()
        # set to None if last_status (nullable) is None
        # and __fields_set__ contains the field
        if self.last_status is None and "last_status" in self.__fields_set__:
            _dict['lastStatus'] = None

        # set to None if last_run_error_message (nullable) is None
        # and __fields_set__ contains the field
        if self.last_run_error_message is None and "last_run_error_message" in self.__fields_set__:
            _dict['lastRunErrorMessage'] = None

        # set to None if type (nullable) is None
        # and __fields_set__ contains the field
        if self.type is None and "type" in self.__fields_set__:
            _dict['type'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1WebhooksPost200ResponseWebhook:
        """Create an instance of ApiV1WebhooksPost200ResponseWebhook from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1WebhooksPost200ResponseWebhook.parse_obj(obj)

        _obj = ApiV1WebhooksPost200ResponseWebhook.parse_obj({
            "id": obj.get("id"),
            "secret_path": obj.get("secretPath") if obj.get("secretPath") is not None else '/',
            "last_status": obj.get("lastStatus"),
            "last_run_error_message": obj.get("lastRunErrorMessage"),
            "is_disabled": obj.get("isDisabled") if obj.get("isDisabled") is not None else False,
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt"),
            "env_id": obj.get("envId"),
            "type": obj.get("type") if obj.get("type") is not None else 'general',
            "project_id": obj.get("projectId"),
            "environment": ApiV1SecretApprovalsGet200ResponseApprovalsInnerEnvironment.from_dict(obj.get("environment")) if obj.get("environment") is not None else None
        })
        return _obj


