# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class ApiV1WorkspaceProjectIdTagsTagIdGet200ResponseWorkspaceTag(BaseModel):
    """
    ApiV1WorkspaceProjectIdTagsTagIdGet200ResponseWorkspaceTag
    """
    id: StrictStr = Field(...)
    slug: StrictStr = Field(...)
    color: Optional[StrictStr] = None
    created_at: datetime = Field(default=..., alias="createdAt")
    updated_at: datetime = Field(default=..., alias="updatedAt")
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    project_id: StrictStr = Field(default=..., alias="projectId")
    created_by_actor_type: Optional[StrictStr] = Field(default='user', alias="createdByActorType")
    name: StrictStr = Field(...)
    __properties = ["id", "slug", "color", "createdAt", "updatedAt", "createdBy", "projectId", "createdByActorType", "name"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1WorkspaceProjectIdTagsTagIdGet200ResponseWorkspaceTag:
        """Create an instance of ApiV1WorkspaceProjectIdTagsTagIdGet200ResponseWorkspaceTag from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if color (nullable) is None
        # and __fields_set__ contains the field
        if self.color is None and "color" in self.__fields_set__:
            _dict['color'] = None

        # set to None if created_by (nullable) is None
        # and __fields_set__ contains the field
        if self.created_by is None and "created_by" in self.__fields_set__:
            _dict['createdBy'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1WorkspaceProjectIdTagsTagIdGet200ResponseWorkspaceTag:
        """Create an instance of ApiV1WorkspaceProjectIdTagsTagIdGet200ResponseWorkspaceTag from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1WorkspaceProjectIdTagsTagIdGet200ResponseWorkspaceTag.parse_obj(obj)

        _obj = ApiV1WorkspaceProjectIdTagsTagIdGet200ResponseWorkspaceTag.parse_obj({
            "id": obj.get("id"),
            "slug": obj.get("slug"),
            "color": obj.get("color"),
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt"),
            "created_by": obj.get("createdBy"),
            "project_id": obj.get("projectId"),
            "created_by_actor_type": obj.get("createdByActorType") if obj.get("createdByActorType") is not None else 'user',
            "name": obj.get("name")
        })
        return _obj


