# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from infisicalapi_client.models.api_v1_workspace_project_slug_roles_post200_response_role_permissions_inner import ApiV1WorkspaceProjectSlugRolesPost200ResponseRolePermissionsInner

class ApiV1WorkspaceProjectSlugRolesPost200ResponseRole(BaseModel):
    """
    ApiV1WorkspaceProjectSlugRolesPost200ResponseRole
    """
    id: StrictStr = Field(...)
    name: StrictStr = Field(...)
    description: Optional[StrictStr] = None
    slug: StrictStr = Field(...)
    permissions: conlist(ApiV1WorkspaceProjectSlugRolesPost200ResponseRolePermissionsInner) = Field(...)
    created_at: datetime = Field(default=..., alias="createdAt")
    updated_at: datetime = Field(default=..., alias="updatedAt")
    project_id: StrictStr = Field(default=..., alias="projectId")
    __properties = ["id", "name", "description", "slug", "permissions", "createdAt", "updatedAt", "projectId"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1WorkspaceProjectSlugRolesPost200ResponseRole:
        """Create an instance of ApiV1WorkspaceProjectSlugRolesPost200ResponseRole from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in permissions (list)
        _items = []
        if self.permissions:
            for _item in self.permissions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['permissions'] = _items
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1WorkspaceProjectSlugRolesPost200ResponseRole:
        """Create an instance of ApiV1WorkspaceProjectSlugRolesPost200ResponseRole from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1WorkspaceProjectSlugRolesPost200ResponseRole.parse_obj(obj)

        _obj = ApiV1WorkspaceProjectSlugRolesPost200ResponseRole.parse_obj({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "slug": obj.get("slug"),
            "permissions": [ApiV1WorkspaceProjectSlugRolesPost200ResponseRolePermissionsInner.from_dict(_item) for _item in obj.get("permissions")] if obj.get("permissions") is not None else None,
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt"),
            "project_id": obj.get("projectId")
        })
        return _obj


