# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from infisicalapi_client.models.api_v1_workspace_workspace_id_audit_logs_get200_response_audit_logs_inner_event import ApiV1WorkspaceWorkspaceIdAuditLogsGet200ResponseAuditLogsInnerEvent

class ApiV1WorkspaceWorkspaceIdAuditLogsGet200ResponseAuditLogsInner(BaseModel):
    """
    ApiV1WorkspaceWorkspaceIdAuditLogsGet200ResponseAuditLogsInner
    """
    id: StrictStr = Field(...)
    ip_address: Optional[StrictStr] = Field(default=None, alias="ipAddress")
    user_agent: Optional[StrictStr] = Field(default=None, alias="userAgent")
    user_agent_type: Optional[StrictStr] = Field(default=None, alias="userAgentType")
    expires_at: Optional[datetime] = Field(default=None, alias="expiresAt")
    created_at: datetime = Field(default=..., alias="createdAt")
    updated_at: datetime = Field(default=..., alias="updatedAt")
    org_id: Optional[StrictStr] = Field(default=None, alias="orgId")
    project_id: Optional[StrictStr] = Field(default=None, alias="projectId")
    event: ApiV1WorkspaceWorkspaceIdAuditLogsGet200ResponseAuditLogsInnerEvent = Field(...)
    actor: ApiV1WorkspaceWorkspaceIdAuditLogsGet200ResponseAuditLogsInnerEvent = Field(...)
    __properties = ["id", "ipAddress", "userAgent", "userAgentType", "expiresAt", "createdAt", "updatedAt", "orgId", "projectId", "event", "actor"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1WorkspaceWorkspaceIdAuditLogsGet200ResponseAuditLogsInner:
        """Create an instance of ApiV1WorkspaceWorkspaceIdAuditLogsGet200ResponseAuditLogsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of event
        if self.event:
            _dict['event'] = self.event.to_dict()
        # override the default output from pydantic by calling `to_dict()` of actor
        if self.actor:
            _dict['actor'] = self.actor.to_dict()
        # set to None if ip_address (nullable) is None
        # and __fields_set__ contains the field
        if self.ip_address is None and "ip_address" in self.__fields_set__:
            _dict['ipAddress'] = None

        # set to None if user_agent (nullable) is None
        # and __fields_set__ contains the field
        if self.user_agent is None and "user_agent" in self.__fields_set__:
            _dict['userAgent'] = None

        # set to None if user_agent_type (nullable) is None
        # and __fields_set__ contains the field
        if self.user_agent_type is None and "user_agent_type" in self.__fields_set__:
            _dict['userAgentType'] = None

        # set to None if expires_at (nullable) is None
        # and __fields_set__ contains the field
        if self.expires_at is None and "expires_at" in self.__fields_set__:
            _dict['expiresAt'] = None

        # set to None if org_id (nullable) is None
        # and __fields_set__ contains the field
        if self.org_id is None and "org_id" in self.__fields_set__:
            _dict['orgId'] = None

        # set to None if project_id (nullable) is None
        # and __fields_set__ contains the field
        if self.project_id is None and "project_id" in self.__fields_set__:
            _dict['projectId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1WorkspaceWorkspaceIdAuditLogsGet200ResponseAuditLogsInner:
        """Create an instance of ApiV1WorkspaceWorkspaceIdAuditLogsGet200ResponseAuditLogsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1WorkspaceWorkspaceIdAuditLogsGet200ResponseAuditLogsInner.parse_obj(obj)

        _obj = ApiV1WorkspaceWorkspaceIdAuditLogsGet200ResponseAuditLogsInner.parse_obj({
            "id": obj.get("id"),
            "ip_address": obj.get("ipAddress"),
            "user_agent": obj.get("userAgent"),
            "user_agent_type": obj.get("userAgentType"),
            "expires_at": obj.get("expiresAt"),
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt"),
            "org_id": obj.get("orgId"),
            "project_id": obj.get("projectId"),
            "event": ApiV1WorkspaceWorkspaceIdAuditLogsGet200ResponseAuditLogsInnerEvent.from_dict(obj.get("event")) if obj.get("event") is not None else None,
            "actor": ApiV1WorkspaceWorkspaceIdAuditLogsGet200ResponseAuditLogsInnerEvent.from_dict(obj.get("actor")) if obj.get("actor") is not None else None
        })
        return _obj


