# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional, Union
from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr

class ApiV1WorkspaceWorkspaceIdTrustedIpsGet200ResponseTrustedIpsInner(BaseModel):
    """
    ApiV1WorkspaceWorkspaceIdTrustedIpsGet200ResponseTrustedIpsInner
    """
    id: StrictStr = Field(...)
    ip_address: StrictStr = Field(default=..., alias="ipAddress")
    type: StrictStr = Field(...)
    prefix: Optional[Union[StrictFloat, StrictInt]] = None
    is_active: Optional[StrictBool] = Field(default=True, alias="isActive")
    comment: Optional[StrictStr] = None
    project_id: StrictStr = Field(default=..., alias="projectId")
    created_at: datetime = Field(default=..., alias="createdAt")
    updated_at: datetime = Field(default=..., alias="updatedAt")
    __properties = ["id", "ipAddress", "type", "prefix", "isActive", "comment", "projectId", "createdAt", "updatedAt"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV1WorkspaceWorkspaceIdTrustedIpsGet200ResponseTrustedIpsInner:
        """Create an instance of ApiV1WorkspaceWorkspaceIdTrustedIpsGet200ResponseTrustedIpsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if prefix (nullable) is None
        # and __fields_set__ contains the field
        if self.prefix is None and "prefix" in self.__fields_set__:
            _dict['prefix'] = None

        # set to None if is_active (nullable) is None
        # and __fields_set__ contains the field
        if self.is_active is None and "is_active" in self.__fields_set__:
            _dict['isActive'] = None

        # set to None if comment (nullable) is None
        # and __fields_set__ contains the field
        if self.comment is None and "comment" in self.__fields_set__:
            _dict['comment'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV1WorkspaceWorkspaceIdTrustedIpsGet200ResponseTrustedIpsInner:
        """Create an instance of ApiV1WorkspaceWorkspaceIdTrustedIpsGet200ResponseTrustedIpsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV1WorkspaceWorkspaceIdTrustedIpsGet200ResponseTrustedIpsInner.parse_obj(obj)

        _obj = ApiV1WorkspaceWorkspaceIdTrustedIpsGet200ResponseTrustedIpsInner.parse_obj({
            "id": obj.get("id"),
            "ip_address": obj.get("ipAddress"),
            "type": obj.get("type"),
            "prefix": obj.get("prefix"),
            "is_active": obj.get("isActive") if obj.get("isActive") is not None else True,
            "comment": obj.get("comment"),
            "project_id": obj.get("projectId"),
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt")
        })
        return _obj


