# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, List, Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, conlist
from infisicalapi_client.models.api_v2_service_token_get200_response_user import ApiV2ServiceTokenGet200ResponseUser

class ApiV2ServiceTokenGet200Response(BaseModel):
    """
    ApiV2ServiceTokenGet200Response
    """
    id: StrictStr = Field(...)
    name: StrictStr = Field(...)
    scopes: Optional[Any] = None
    permissions: conlist(StrictStr) = Field(...)
    last_used: Optional[datetime] = Field(default=None, alias="lastUsed")
    expires_at: Optional[datetime] = Field(default=None, alias="expiresAt")
    secret_hash: StrictStr = Field(default=..., alias="secretHash")
    encrypted_key: Optional[StrictStr] = Field(default=None, alias="encryptedKey")
    iv: Optional[StrictStr] = None
    tag: Optional[StrictStr] = None
    created_at: datetime = Field(default=..., alias="createdAt")
    updated_at: datetime = Field(default=..., alias="updatedAt")
    created_by: StrictStr = Field(default=..., alias="createdBy")
    project_id: StrictStr = Field(default=..., alias="projectId")
    workspace: StrictStr = Field(...)
    user: ApiV2ServiceTokenGet200ResponseUser = Field(...)
    id: StrictStr = Field(default=..., alias="_id")
    v: Optional[Union[StrictFloat, StrictInt]] = Field(default=0, alias="__v")
    __properties = ["id", "name", "scopes", "permissions", "lastUsed", "expiresAt", "secretHash", "encryptedKey", "iv", "tag", "createdAt", "updatedAt", "createdBy", "projectId", "workspace", "user", "_id", "__v"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV2ServiceTokenGet200Response:
        """Create an instance of ApiV2ServiceTokenGet200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # set to None if scopes (nullable) is None
        # and __fields_set__ contains the field
        if self.scopes is None and "scopes" in self.__fields_set__:
            _dict['scopes'] = None

        # set to None if last_used (nullable) is None
        # and __fields_set__ contains the field
        if self.last_used is None and "last_used" in self.__fields_set__:
            _dict['lastUsed'] = None

        # set to None if expires_at (nullable) is None
        # and __fields_set__ contains the field
        if self.expires_at is None and "expires_at" in self.__fields_set__:
            _dict['expiresAt'] = None

        # set to None if encrypted_key (nullable) is None
        # and __fields_set__ contains the field
        if self.encrypted_key is None and "encrypted_key" in self.__fields_set__:
            _dict['encryptedKey'] = None

        # set to None if iv (nullable) is None
        # and __fields_set__ contains the field
        if self.iv is None and "iv" in self.__fields_set__:
            _dict['iv'] = None

        # set to None if tag (nullable) is None
        # and __fields_set__ contains the field
        if self.tag is None and "tag" in self.__fields_set__:
            _dict['tag'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV2ServiceTokenGet200Response:
        """Create an instance of ApiV2ServiceTokenGet200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV2ServiceTokenGet200Response.parse_obj(obj)

        _obj = ApiV2ServiceTokenGet200Response.parse_obj({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "scopes": obj.get("scopes"),
            "permissions": obj.get("permissions"),
            "last_used": obj.get("lastUsed"),
            "expires_at": obj.get("expiresAt"),
            "secret_hash": obj.get("secretHash"),
            "encrypted_key": obj.get("encryptedKey"),
            "iv": obj.get("iv"),
            "tag": obj.get("tag"),
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt"),
            "created_by": obj.get("createdBy"),
            "project_id": obj.get("projectId"),
            "workspace": obj.get("workspace"),
            "user": ApiV2ServiceTokenGet200ResponseUser.from_dict(obj.get("user")) if obj.get("user") is not None else None,
            "id": obj.get("_id"),
            "v": obj.get("__v") if obj.get("__v") is not None else 0
        })
        return _obj


