# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, List, Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, conlist

class ApiV2ServiceTokenGet200ResponseUser(BaseModel):
    """
    ApiV2ServiceTokenGet200ResponseUser
    """
    auth_methods: Optional[conlist(StrictStr)] = Field(default=None, alias="authMethods")
    id: StrictStr = Field(...)
    created_at: datetime = Field(default=..., alias="createdAt")
    updated_at: datetime = Field(default=..., alias="updatedAt")
    devices: Optional[Any] = None
    email: Optional[StrictStr] = None
    first_name: Optional[StrictStr] = Field(default=None, alias="firstName")
    last_name: Optional[StrictStr] = Field(default=None, alias="lastName")
    mfa_methods: Optional[conlist(StrictStr)] = Field(default=None, alias="mfaMethods")
    v: Optional[Union[StrictFloat, StrictInt]] = Field(default=0, alias="__v")
    id: StrictStr = Field(default=..., alias="_id")
    __properties = ["authMethods", "id", "createdAt", "updatedAt", "devices", "email", "firstName", "lastName", "mfaMethods", "__v", "_id"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV2ServiceTokenGet200ResponseUser:
        """Create an instance of ApiV2ServiceTokenGet200ResponseUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if auth_methods (nullable) is None
        # and __fields_set__ contains the field
        if self.auth_methods is None and "auth_methods" in self.__fields_set__:
            _dict['authMethods'] = None

        # set to None if devices (nullable) is None
        # and __fields_set__ contains the field
        if self.devices is None and "devices" in self.__fields_set__:
            _dict['devices'] = None

        # set to None if email (nullable) is None
        # and __fields_set__ contains the field
        if self.email is None and "email" in self.__fields_set__:
            _dict['email'] = None

        # set to None if first_name (nullable) is None
        # and __fields_set__ contains the field
        if self.first_name is None and "first_name" in self.__fields_set__:
            _dict['firstName'] = None

        # set to None if last_name (nullable) is None
        # and __fields_set__ contains the field
        if self.last_name is None and "last_name" in self.__fields_set__:
            _dict['lastName'] = None

        # set to None if mfa_methods (nullable) is None
        # and __fields_set__ contains the field
        if self.mfa_methods is None and "mfa_methods" in self.__fields_set__:
            _dict['mfaMethods'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV2ServiceTokenGet200ResponseUser:
        """Create an instance of ApiV2ServiceTokenGet200ResponseUser from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV2ServiceTokenGet200ResponseUser.parse_obj(obj)

        _obj = ApiV2ServiceTokenGet200ResponseUser.parse_obj({
            "auth_methods": obj.get("authMethods"),
            "id": obj.get("id"),
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt"),
            "devices": obj.get("devices"),
            "email": obj.get("email"),
            "first_name": obj.get("firstName"),
            "last_name": obj.get("lastName"),
            "mfa_methods": obj.get("mfaMethods"),
            "v": obj.get("__v") if obj.get("__v") is not None else 0,
            "id": obj.get("_id")
        })
        return _obj


