# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, conlist, validator
from infisicalapi_client.models.api_v2_service_token_post_request_scopes_inner import ApiV2ServiceTokenPostRequestScopesInner

class ApiV2ServiceTokenPostRequest(BaseModel):
    """
    ApiV2ServiceTokenPostRequest
    """
    name: StrictStr = Field(...)
    workspace_id: StrictStr = Field(default=..., alias="workspaceId")
    scopes: conlist(ApiV2ServiceTokenPostRequestScopesInner, min_items=1) = Field(...)
    encrypted_key: StrictStr = Field(default=..., alias="encryptedKey")
    iv: StrictStr = Field(...)
    tag: StrictStr = Field(...)
    expires_in: Optional[Union[StrictFloat, StrictInt]] = Field(default=..., alias="expiresIn")
    permissions: conlist(StrictStr) = Field(...)
    __properties = ["name", "workspaceId", "scopes", "encryptedKey", "iv", "tag", "expiresIn", "permissions"]

    @validator('permissions')
    def permissions_validate_enum(cls, value):
        """Validates the enum"""
        for i in value:
            if i not in ('read', 'write'):
                raise ValueError("each list item must be one of ('read', 'write')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV2ServiceTokenPostRequest:
        """Create an instance of ApiV2ServiceTokenPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in scopes (list)
        _items = []
        if self.scopes:
            for _item in self.scopes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['scopes'] = _items
        # set to None if expires_in (nullable) is None
        # and __fields_set__ contains the field
        if self.expires_in is None and "expires_in" in self.__fields_set__:
            _dict['expiresIn'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV2ServiceTokenPostRequest:
        """Create an instance of ApiV2ServiceTokenPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV2ServiceTokenPostRequest.parse_obj(obj)

        _obj = ApiV2ServiceTokenPostRequest.parse_obj({
            "name": obj.get("name"),
            "workspace_id": obj.get("workspaceId"),
            "scopes": [ApiV2ServiceTokenPostRequestScopesInner.from_dict(_item) for _item in obj.get("scopes")] if obj.get("scopes") is not None else None,
            "encrypted_key": obj.get("encryptedKey"),
            "iv": obj.get("iv"),
            "tag": obj.get("tag"),
            "expires_in": obj.get("expiresIn"),
            "permissions": obj.get("permissions")
        })
        return _obj


