# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr

class ApiV2UsersMeSessionsGet200ResponseInner(BaseModel):
    """
    ApiV2UsersMeSessionsGet200ResponseInner
    """
    id: StrictStr = Field(...)
    ip: StrictStr = Field(...)
    user_agent: Optional[StrictStr] = Field(default=None, alias="userAgent")
    refresh_version: Optional[Union[StrictFloat, StrictInt]] = Field(default=1, alias="refreshVersion")
    access_version: Optional[Union[StrictFloat, StrictInt]] = Field(default=1, alias="accessVersion")
    last_used: datetime = Field(default=..., alias="lastUsed")
    created_at: datetime = Field(default=..., alias="createdAt")
    updated_at: datetime = Field(default=..., alias="updatedAt")
    user_id: StrictStr = Field(default=..., alias="userId")
    __properties = ["id", "ip", "userAgent", "refreshVersion", "accessVersion", "lastUsed", "createdAt", "updatedAt", "userId"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV2UsersMeSessionsGet200ResponseInner:
        """Create an instance of ApiV2UsersMeSessionsGet200ResponseInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if user_agent (nullable) is None
        # and __fields_set__ contains the field
        if self.user_agent is None and "user_agent" in self.__fields_set__:
            _dict['userAgent'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV2UsersMeSessionsGet200ResponseInner:
        """Create an instance of ApiV2UsersMeSessionsGet200ResponseInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV2UsersMeSessionsGet200ResponseInner.parse_obj(obj)

        _obj = ApiV2UsersMeSessionsGet200ResponseInner.parse_obj({
            "id": obj.get("id"),
            "ip": obj.get("ip"),
            "user_agent": obj.get("userAgent"),
            "refresh_version": obj.get("refreshVersion") if obj.get("refreshVersion") is not None else 1,
            "access_version": obj.get("accessVersion") if obj.get("accessVersion") is not None else 1,
            "last_used": obj.get("lastUsed"),
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt"),
            "user_id": obj.get("userId")
        })
        return _obj


