# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, conlist
from infisicalapi_client.models.api_v1_pki_certificates_serial_number_get200_response_certificate import ApiV1PkiCertificatesSerialNumberGet200ResponseCertificate

class ApiV2WorkspaceSlugCertificatesGet200Response(BaseModel):
    """
    ApiV2WorkspaceSlugCertificatesGet200Response
    """
    certificates: conlist(ApiV1PkiCertificatesSerialNumberGet200ResponseCertificate) = Field(...)
    total_count: Union[StrictFloat, StrictInt] = Field(default=..., alias="totalCount")
    __properties = ["certificates", "totalCount"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV2WorkspaceSlugCertificatesGet200Response:
        """Create an instance of ApiV2WorkspaceSlugCertificatesGet200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in certificates (list)
        _items = []
        if self.certificates:
            for _item in self.certificates:
                if _item:
                    _items.append(_item.to_dict())
            _dict['certificates'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV2WorkspaceSlugCertificatesGet200Response:
        """Create an instance of ApiV2WorkspaceSlugCertificatesGet200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV2WorkspaceSlugCertificatesGet200Response.parse_obj(obj)

        _obj = ApiV2WorkspaceSlugCertificatesGet200Response.parse_obj({
            "certificates": [ApiV1PkiCertificatesSerialNumberGet200ResponseCertificate.from_dict(_item) for _item in obj.get("certificates")] if obj.get("certificates") is not None else None,
            "total_count": obj.get("totalCount")
        })
        return _obj


