# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional, Union
from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr, conlist, constr

class ApiV3SecretsBatchRawPatchRequestSecretsInner(BaseModel):
    """
    ApiV3SecretsBatchRawPatchRequestSecretsInner
    """
    secret_key: StrictStr = Field(default=..., alias="secretKey", description="The name of the secret to update.")
    secret_value: StrictStr = Field(default=..., alias="secretValue", description="The new value of the secret.")
    secret_comment: Optional[StrictStr] = Field(default=None, alias="secretComment", description="Update comment to the secret.")
    skip_multiline_encoding: Optional[StrictBool] = Field(default=None, alias="skipMultilineEncoding", description="Skip multiline encoding for the secret value.")
    new_secret_name: Optional[constr(strict=True, min_length=1)] = Field(default=None, alias="newSecretName", description="The new name for the secret")
    tag_ids: Optional[conlist(StrictStr)] = Field(default=None, alias="tagIds", description="The ID of the tags to be attached to the updated secret.")
    secret_reminder_note: Optional[StrictStr] = Field(default=None, alias="secretReminderNote", description="Note to be attached in notification email")
    secret_reminder_repeat_days: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="secretReminderRepeatDays", description="Interval for secret rotation notifications, measured in days")
    __properties = ["secretKey", "secretValue", "secretComment", "skipMultilineEncoding", "newSecretName", "tagIds", "secretReminderNote", "secretReminderRepeatDays"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV3SecretsBatchRawPatchRequestSecretsInner:
        """Create an instance of ApiV3SecretsBatchRawPatchRequestSecretsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if secret_reminder_note (nullable) is None
        # and __fields_set__ contains the field
        if self.secret_reminder_note is None and "secret_reminder_note" in self.__fields_set__:
            _dict['secretReminderNote'] = None

        # set to None if secret_reminder_repeat_days (nullable) is None
        # and __fields_set__ contains the field
        if self.secret_reminder_repeat_days is None and "secret_reminder_repeat_days" in self.__fields_set__:
            _dict['secretReminderRepeatDays'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV3SecretsBatchRawPatchRequestSecretsInner:
        """Create an instance of ApiV3SecretsBatchRawPatchRequestSecretsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV3SecretsBatchRawPatchRequestSecretsInner.parse_obj(obj)

        _obj = ApiV3SecretsBatchRawPatchRequestSecretsInner.parse_obj({
            "secret_key": obj.get("secretKey"),
            "secret_value": obj.get("secretValue"),
            "secret_comment": obj.get("secretComment"),
            "skip_multiline_encoding": obj.get("skipMultilineEncoding"),
            "new_secret_name": obj.get("newSecretName"),
            "tag_ids": obj.get("tagIds"),
            "secret_reminder_note": obj.get("secretReminderNote"),
            "secret_reminder_repeat_days": obj.get("secretReminderRepeatDays")
        })
        return _obj


