# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist

class ApiV3SecretsBatchRawPostRequestSecretsInner(BaseModel):
    """
    ApiV3SecretsBatchRawPostRequestSecretsInner
    """
    secret_key: StrictStr = Field(default=..., alias="secretKey", description="The name of the secret to create.")
    secret_value: StrictStr = Field(default=..., alias="secretValue", description="The value of the secret to create.")
    secret_comment: Optional[StrictStr] = Field(default='', alias="secretComment", description="Attach a comment to the secret.")
    skip_multiline_encoding: Optional[StrictBool] = Field(default=None, alias="skipMultilineEncoding", description="Skip multiline encoding for the secret value.")
    metadata: Optional[Dict[str, StrictStr]] = None
    tag_ids: Optional[conlist(StrictStr)] = Field(default=None, alias="tagIds", description="The ID of the tags to be attached to the created secret.")
    __properties = ["secretKey", "secretValue", "secretComment", "skipMultilineEncoding", "metadata", "tagIds"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV3SecretsBatchRawPostRequestSecretsInner:
        """Create an instance of ApiV3SecretsBatchRawPostRequestSecretsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV3SecretsBatchRawPostRequestSecretsInner:
        """Create an instance of ApiV3SecretsBatchRawPostRequestSecretsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV3SecretsBatchRawPostRequestSecretsInner.parse_obj(obj)

        _obj = ApiV3SecretsBatchRawPostRequestSecretsInner.parse_obj({
            "secret_key": obj.get("secretKey"),
            "secret_value": obj.get("secretValue"),
            "secret_comment": obj.get("secretComment") if obj.get("secretComment") is not None else '',
            "skip_multiline_encoding": obj.get("skipMultilineEncoding"),
            "metadata": obj.get("metadata"),
            "tag_ids": obj.get("tagIds")
        })
        return _obj


